/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.TemplateEntity;
import com.ejianc.business.wzxt.service.ITemplateService;
import com.ejianc.business.wzxt.vo.TemplateVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"template"})
public class TemplateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITemplateService service;
    @Resource
    private IMaterialApi iMaterialApi;
    private static final String billCodeRule = "CSCEC5B_WZXT_WZMB";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO templateVO) {
        return this.service.saveOrUpdate(templateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
        TemplateEntity entity = (TemplateEntity)((Object)this.service.selectById(id));
        TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTemplateDetail"})
    @ResponseBody
    public CommonResponse<List<TemplateVO>> queryTemplateDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="materialId") Long materialId) {
        List<TemplateVO> templateVOS = this.service.queryTemplateDetail(projectId, materialId);
        if (CollectionUtils.isEmpty(templateVOS)) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return CommonResponse.success((String)"\u8be6\u60c5\u67e5\u8be2\u6210\u529f", templateVOS);
    }

    @RequestMapping
    @ResponseBody
    public CommonResponse<String> queryMaterialTypeById(@RequestParam(value="materialTypeId") Long materialTypeId) {
        TemplateEntity typeId = (TemplateEntity)((Object)this.service.getById(materialTypeId));
        if (typeId == null) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        Map tt;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateCode");
        fuzzyFields.add("templateName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List complexParams = param.getComplexParams();
        if (complexParams != null && complexParams.size() > 1 && (tt = ((ComplexParam)((ComplexParam)complexParams.get(1)).getComplexParams().get(1)).getParams()).containsKey("materialTypeId")) {
            List materialTypeIds = (List)((Parameter)tt.get("materialTypeId")).getValue();
            CommonResponse listCommonResponse = this.iMaterialApi.queryCategoryListByChildren(materialTypeIds);
            List MaterialCategoryVOs = (List)listCommonResponse.getData();
            this.logger.info(listCommonResponse.getMsg() + "\u5206\u7c7b\u4e3b\u952e\u8fd4\u56de-----materialTypepks" + MaterialCategoryVOs);
            List materialTypepks = MaterialCategoryVOs.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
            this.logger.info("\u5206\u7c7b\u4e3b\u952e-----materialTypepks" + materialTypepks);
            ((ComplexParam)((ComplexParam)param.getComplexParams().get(1)).getComplexParams().get(1)).getParams().put("materialTypeId", new Parameter("in", materialTypepks));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

