package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.mapper.ControlPlanMapper;
import com.ejianc.business.wzxt.service.IControlPlanService;
import com.ejianc.business.wzxt.vo.ConCheckVO;
import com.ejianc.business.wzxt.vo.ControlPlanRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 总控计划实体
 * 
 * @author generator
 * 
 */
@Service("controlPlanService")
public class ControlPlanServiceImpl extends BaseServiceImpl<ControlPlanMapper, ControlPlanEntity> implements IControlPlanService{

    @Override
    public List<ControlPlanRefVO> getControlPlan(Page<ControlPlanRefVO> page, QueryWrapper wrapper,Long projectId,Long tenantId) {
        List<ControlPlanRefVO> list = baseMapper.getControlPlan(page, wrapper,projectId,tenantId);
        return list;
    }

    @Override
    public List<ConCheckVO> getNumByProjectId(ConCheckVO conCheckVO) {
        //根据项目主键和所选物料主键查询相应数量
        List<ConCheckVO> controlNumList =  baseMapper.getControlNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<ConCheckVO> checkNumList =  baseMapper.getCheckNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<Long> materialIds = conCheckVO.getMaterialIds();
        List<ConCheckVO> conCheckVOList = new ArrayList<>();
        //组合数据
        for (Long material : materialIds){
            ConCheckVO conCheck = new ConCheckVO();
            conCheck.setMaterialId(material);
            for (ConCheckVO controlNumVO : controlNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setControlNum(controlNumVO.getControlNum());
                }
            }
            for (ConCheckVO controlNumVO : checkNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setCheckNum(controlNumVO.getCheckNum());
                }
            }
            conCheckVOList.add(conCheck);
        }
        return conCheckVOList;
    }

    @Override
    public List<ConCheckVO> getCGNumByProjectId(ConCheckVO conCheckVO) {
        //根据项目主键和所选物料主键查询相应数量
        List<ConCheckVO> controlNumList =  baseMapper.getControlNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<ConCheckVO> checkNumList =  baseMapper.getCheckCGNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<Long> materialIds = conCheckVO.getMaterialIds();
        List<ConCheckVO> conCheckVOList = new ArrayList<>();
        //组合数据
        for (Long material : materialIds){
            ConCheckVO conCheck = new ConCheckVO();
            conCheck.setMaterialId(material);
            for (ConCheckVO controlNumVO : controlNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setControlNum(controlNumVO.getControlNum());
                }
            }
            for (ConCheckVO controlNumVO : checkNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setCheckNum(controlNumVO.getCheckNum());
                }
            }
            conCheckVOList.add(conCheck);
        }
        return conCheckVOList;
    }
}
