package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.mapper.ExitMapper;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitGFVO;
import com.ejianc.business.wzxt.vo.ExitReportVO;
import com.ejianc.business.wzxt.vo.ExitVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 退场单
 * 
 * @author generator
 * 
 */
@Service("exitService")
public class ExitServiceImpl extends BaseServiceImpl<ExitMapper, ExitEntity> implements IExitService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjExitUrl}")
    private String wjExitUrl;

    private static final String WJ_WZXT_EXIT = "WJ_WZXT_EXIT";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IExitApplyService exitApplyService;


    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        StringBuffer materialName = new StringBuffer();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(saveorUpdateVO.getExitDetail())){
            saveorUpdateVO.getExitDetail().forEach(vo -> {
                materialName.append(vo.getMaterialName()+",");
            });
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitEntity entity = BeanMapper.map(saveorUpdateVO, ExitEntity.class);
        entity.setConfirmFlag(0);//待确认
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_EXIT, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        ExitApplyEntity exitApplyEntity = exitApplyService.selectById(entity.getApplyId());
        ExitVO resVo =  BeanMapper.map(entity, ExitVO.class);
        resVo.setApplyState(exitApplyEntity.getApplyState());
        return resVo;
    }

    @Override
    public CommonResponse<ExitVO> updateConfirmFlag(ExitVO exitVO) {
        ExitEntity entity = super.getById(exitVO.getId());
        entity.setConfirmFlag(exitVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitVO.getConfirmerId());
        entity.setConfirmerName(exitVO.getConfirmerName());
        entity.setConfirmNote(exitVO.getConfirmNote());
        String msg = "确认";
        //拒绝单据改为自由态
        if (2 == exitVO.getConfirmFlag()) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            msg = "拒绝";
        }
        super.saveOrUpdate(entity, false);
        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(entity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-wzxt-frontend/#/exit/card?id="+entity.getId();
        String subject = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】"+msg+"。";
        String content = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】"+msg+"。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(entity.getTenantId()),entity);
        return CommonResponse.success();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,ExitEntity entity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams  = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/walkoffIndex/details?id="+entity.getId()+"&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    @Override
    public CommonResponse<String>  pushConfirmEntity(Map<String, String> headers, ExitEntity exitEntity){
        String url = wjExitUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));// 主键
        purchase.setApplyId(String.valueOf(exitEntity.getApplyId()));
        purchase.setOrgId(exitEntity.getParentOrgSourceId());;// 组织主键   传来源组织主键
        purchase.setOrgName(exitEntity.getOrgName());
        purchase.setConfirmFlag(0);
        purchase.setProjectId(exitEntity.getProjectSourceId());// 项目主键    传来源项目主键
        purchase.setProjectName(exitEntity.getProjectName());
        purchase.setBillCode(exitEntity.getBillCode());// 编码
        purchase.setSupplierId(exitEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        purchase.setSupplierName(exitEntity.getSupplierName());
        purchase.setContractId(exitEntity.getContractId());// 合同主键
        purchase.setContractName(exitEntity.getContractName());
        purchase.setContractCode(exitEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setExitDate(formatter.format(exitEntity.getExitDate()));
        purchase.setExitNote(exitEntity.getExitNote());
        purchase.setLinkName(exitEntity.getLinkName());
        purchase.setLinkTelephone(exitEntity.getLinkTelephone());
        purchase.setPkCreator("xpt");
        purchase.setCreatorName("五局新平台");
        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
        CommonResponse<List<AttachmentVO>> sceneurRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210318000000001","imgUpload2",null);
        if(sceneurRes.isSuccess()){
            List<String> sceneurlList = new ArrayList<>();
            sceneurlList.addAll(sceneurRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(sceneurlList)){
                purchase.setSceneurl(String.join(",", sceneurlList));
            }
        }

        CommonResponse<List<AttachmentVO>> czsignurlRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210318000000001","imgUpload3",null);
        List<String> czsignurllList = new ArrayList<>();
        if(czsignurlRes.isSuccess()){
            czsignurllList.addAll(czsignurlRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(czsignurllList)){
                purchase.setCzsignurl(String.join(",", czsignurllList));
            }
        }

        CommonResponse<List<AttachmentVO>> jlsingurlRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210318000000001","imgUpload4",null);
        List<String> jlsingurlList = new ArrayList<>();
        if(jlsingurlRes.isSuccess()){
            jlsingurlList.addAll(jlsingurlRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(jlsingurlList)){
                purchase.setJlsingurl(String.join(",", jlsingurlList));
            }
        }

        if(CollectionUtils.isNotEmpty(exitEntity.getExitDetail())){
            List<ExitDetailGFVO> list = new ArrayList<>();
            exitEntity.getExitDetail().forEach(e -> {
                    //非末级才需要同步
                    ExitDetailGFVO vo = new ExitDetailGFVO();
                    vo.setId(String.valueOf(e.getId()));// 子表主键
                    vo.setExitId(String.valueOf(exitEntity.getId()));// 主表主键
                    vo.setMaterialId(e.getMaterialSourceId());// 材料主键 传来源主键
                    vo.setMaterialCode(e.getMaterialCode());// 材料编码"
                    vo.setMaterialTypeName(e.getMaterialTypeName());
                    vo.setMaterialName(e.getMaterialName());// 材料名称
                    vo.setSpec(e.getSpec());// 规格型号
                    vo.setUnit(e.getUnit());// 单位
                    vo.setStopDate(formatter.format(e.getStopDate()));
                    vo.setDef1(e.getDef1());
                    vo.setDef2(e.getDef2());
                    vo.setDef3(e.getDef3());
                    vo.setDef4(e.getDef4());
                    vo.setDef5(e.getDef5());
                    vo.setMemo(e.getMemo());
                    vo.setApplyNums(e.getApplyNums()==null?BigDecimal.ZERO:e.getApplyNums());
                    vo.setExitNums(e.getExitNums()==null?BigDecimal.ZERO:e.getExitNums());
                    vo.setExitNumsSum(e.getExitNumsSum()==null?BigDecimal.ZERO:e.getExitNumsSum());
                    list.add(vo);
            });
            purchase.setExitDetailList(list);
        }

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }

    @Override
    public List<ExitReportVO> queryExitReport(QueryWrapper queryWrapper) {
        return baseMapper.queryExitReport(queryWrapper);
    }

    @Override
    public List<ExitReportVO> queryZlReports(QueryWrapper queryWrapper,Long projectId,Long supplierId) {
        return baseMapper.queryZlReport(queryWrapper,projectId,supplierId);
    }

    @Override
    public List<ExitReportVO> queryCgReports(QueryWrapper queryWrapper, Long projectId) {
        return baseMapper.queryCgReports(queryWrapper,projectId);
    }
}
