package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.vo.ConCheckVO;
import com.ejianc.business.wzxt.vo.CtPlanRefVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.CtPlanMapper;
import com.ejianc.business.wzxt.bean.CtPlanEntity;
import com.ejianc.business.wzxt.service.ICtPlanService;

import java.util.ArrayList;
import java.util.List;

/**
 * 消耗材总控计划实体
 *
 * @author generator
 *
 */
@Service("ctPlanService")
public class CtPlanServiceImpl extends BaseServiceImpl<CtPlanMapper, CtPlanEntity> implements ICtPlanService{

    @Override
    public List<CtPlanRefVO> getControlPlan(Page<CtPlanRefVO> page, QueryWrapper wrapper, Long projectId, Long tenantid) {
        List<CtPlanRefVO> list = baseMapper.getControlPlan(page, wrapper,projectId,tenantid);
        return list;
    }

    @Override
    public List<ConCheckVO> getNumByProjectId(ConCheckVO conCheckVO) {
        //根据项目主键和所选物料主键查询相应数量
        List<ConCheckVO> controlNumList =  baseMapper.getControlNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<ConCheckVO> checkNumList =  baseMapper.getCheckNum(conCheckVO.getProjectId(),conCheckVO.getMaterialIds());
        List<Long> materialIds = conCheckVO.getMaterialIds();
        List<ConCheckVO> conCheckVOList = new ArrayList<>();
        //组合数据
        for (Long material : materialIds){
            ConCheckVO conCheck = new ConCheckVO();
            conCheck.setMaterialId(material);
            for (ConCheckVO controlNumVO : controlNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setControlNum(controlNumVO.getControlNum());
                }
            }
            for (ConCheckVO controlNumVO : checkNumList){
                if (controlNumVO.getMaterialId().equals(material)){
                    conCheck.setCheckNum(controlNumVO.getCheckNum());
                }
            }
            conCheckVOList.add(conCheck);
        }
        return conCheckVOList;
    }
}
