package com.ejianc.business.wzxt.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/projectConfigure/")
public class ProjectConfigureApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectConfigureService projectConfigureService;

	@RequestMapping(value = "/check", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> check(@RequestParam(value = "projectId", required = false) Long projectId,
										 @RequestParam(value = "mroProjectId", required = false) Long mroProjectId) {
		LambdaQueryWrapper<ProjectConfigureEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ProjectConfigureEntity::getProjectId, projectId);
		List<ProjectConfigureEntity> entityList = projectConfigureService.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entityList)) {
			return CommonResponse.error("该项目已做过关联设置");
		}
		queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ProjectConfigureEntity::getMroProjectId, mroProjectId);
		entityList = projectConfigureService.list(queryWrapper);
		if (CollectionUtils.isNotEmpty(entityList)) {
			return CommonResponse.error("该MRO项目已关联过其他项目");
		}

		return CommonResponse.success("校验成功！");
	}

}
