package com.ejianc.business.wzxt.util;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MroSignUtils {

        public static String encrypt(String signature) throws RuntimeException {
            return encrypt(signature, "", false);
        }

        public static String encrypt(String signature, String encode) throws RuntimeException {
            return encrypt(signature, encode, false);
        }

        public static String encrypt(String signature, String encode, boolean isUpperCase) throws RuntimeException {
            if (signature == null) {
                return null;
            } else {
                MessageDigest md5;

                try {
                    md5 = MessageDigest.getInstance("MD5");
                } catch (NoSuchAlgorithmException var8) {
                    throw new RuntimeException("加密算法错误", var8);
                }

                String ret;

                byte[] plainText;
                try {
                    if (StringUtils.isBlank(encode)) {
                        plainText = signature.getBytes();
                    } else {
                        plainText = signature.getBytes(encode);
                    }
                } catch (UnsupportedEncodingException var7) {
                    throw new RuntimeException("MD5加密异常", var7);
                }

                md5.update(plainText);
                ret = hexDump(md5.digest(), isUpperCase);
                return ret;
            }
        }

        private static String hexDump(byte[] bArray, boolean isUpperCase) {
            StringBuilder sb = new StringBuilder(bArray.length);

            for (byte b : bArray) {
                String sTemp = Integer.toHexString(255 & b);
                if (sTemp.length() < 2) {
                    sb.append(0);
                }

                if (isUpperCase) {
                    sb.append(sTemp.toUpperCase());
                } else {
                    sb.append(sTemp);
                }
            }

            return sb.toString();
        }
}
