package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 验收实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService service;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveorUpdateVO) {
        // 保存态
        saveorUpdateVO.setSaveState(1);
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description saveOrUpdateTemp 暂存或者修改
     */
    @RequestMapping(value = "/saveOrUpdateTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdateTemp(@RequestBody CheckVO saveorUpdateVO) {
        // 暂存态
        saveorUpdateVO.setSaveState(0);
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description deliveryToCheck 发货单生成验收单
     * @param id    发货单主键
     */
    @RequestMapping(value = "/deliveryToCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> deliveryToCheck(Long id) {
        return CommonResponse.success("保存或修改单据成功！",service.deliveryToCheck(id));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        List<Long> ids = vos.stream().map(CheckVO::getId).collect(Collectors.toList());
        service.deleteIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("contractName");
//        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
//        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 保存态
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 保存态
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }
        IPage<CheckEntity> pageData= service.queryPage(param,false);
        List<CheckVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                String checkTypeName = "";
                if("1".equals(vo.getCheckType())) {
                    checkTypeName = "自购消耗材";
                } else if("2".equals(vo.getCheckType())) {
                    checkTypeName = "自购周转材";
                } else if("3".equals(vo.getCheckType())) {
                    checkTypeName = "租赁周转材";
                } else if("4".equals(vo.getCheckType())) {
                    checkTypeName = "零星采购";
                }
                vo.setCheckTypeName(checkTypeName);
                String smartStatusName = "";
                if("1".equals(vo.getSmartStatus())) {
                    smartStatusName = "是";
                } else {
                    smartStatusName = "否";
                }
                vo.setSmartStatusName(smartStatusName);
                StringBuffer checkResult = new StringBuffer();
                if("1".equals(vo.getIsRequirement())){
                    checkResult.append("质量要求：满足 ");
                } else {
                    checkResult.append("质量要求：不满足 ");
                }
                if("1".equals(vo.getIsStandard())){
                    checkResult.append("合同要求：满足 ");
                } else {
                    checkResult.append("合同要求：不满足 ");
                }
                if("1".equals(vo.getIsaddrecord())){
                    checkResult.append("是否补录：是");
                } else {
                    checkResult.append("是否补录：否");
                }
                vo.setCheckResult(checkResult.toString());
                String useStateName = "";
                if(vo.getUseState() != null && vo.getUseState() == 1) {
                    useStateName = "已推送";
                } else {
                    useStateName = "未推送";
                }
                vo.setUseStateName(useStateName);
                if(vo.getIsPurchase() != null && vo.getIsPurchase().equals("0")) {
                    vo.setIsPurchaseName("其他");
                }
                if(vo.getIsPurchase() != null && vo.getIsPurchase().equals("1")) {
                    vo.setIsPurchaseName("材料采购");
                }
                if(vo.getIsPurchase() != null && vo.getIsPurchase().equals("2")) {
                    vo.setIsPurchaseName("周转材租赁");
                }

                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportDetails", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetails(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<JSONObject> res = this.queryDetailsList(param);
        List<CheckDetailsVO> list = new ArrayList<>();
        if(res.getData() != null){
            JSONArray jsonArray = res.getData().getJSONArray("records");
            list = JSONObject.parseArray(jsonArray.toJSONString(),  CheckDetailsVO.class);
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                String useStateName = "";
                if(vo.getUseState() != null && vo.getUseState() == 1) {
                    useStateName = "已推送NC";
                } else {
                    useStateName = "未推送NC";
                }
                vo.setUseStateName(useStateName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkDetailsExport.xlsx", beans, response);
    }

    /**
     * @Description querTempList 查询暂存列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTempList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryTempList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 暂存态
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description getcount 暂存条数
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/getcount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<CheckVO>> response = this.queryTempList(param);
        return CommonResponse.success("查询成功！",response.getData().getTotal());
    }

    /**
     * @Description querCheckedList 查询已验收列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCheckedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryCheckedList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("supplierTenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 已验收
        param.getParams().put("checkState", new Parameter(QueryParam.EQ, 1));

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryAnalysisList 查询物资验收分析
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAnalysisList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryAnalysisList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织权限 */
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> commonOrgIds = new ArrayList<>();
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }

        Page<CheckAnalysisVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CheckAnalysisVO> list = service.querAnalysisList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Description queryDetailsList 查询现场验收明细
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetailsList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailsList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织权限 */
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> commonOrgIds = new ArrayList<>();
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }

        Page<CheckDetailsVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CheckDetailsVO> list = service.queryDetailsList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Description queryDetail 登录人获取 最近一次项目等信息
     * @param
     * @return
     */
    @RequestMapping(value = "/queryLatelyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryLatelyDetail() {
        List<CheckEntity> details = null;
        LambdaQueryWrapper<CheckEntity> lambda = Wrappers.<CheckEntity>lambdaQuery();
        lambda.eq(CheckEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(CheckEntity::getCreateUserCode,InvocationInfoProxy.getUsercode());
        lambda.orderByDesc(CheckEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0), CheckVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description queryLastVOByProject 根据项目&供应商查询最近信息，如果没有再根据项目查
     * @param
     * @return
     */
    @RequestMapping(value = "/queryLastVOByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryLastVOByProject(Long projectId,Long supplierId) {
        List<CheckEntity> details = null;
        LambdaQueryWrapper<CheckEntity> lambda = Wrappers.<CheckEntity>lambdaQuery();
        lambda.eq(CheckEntity::getTenantId, InvocationInfoProxy.getTenantid());//租户
        lambda.eq(CheckEntity::getProjectId, projectId);//项目
        lambda.eq(CheckEntity::getSupplierId, supplierId);//供应商
        lambda.eq(CheckEntity::getUseState, 1);//已推送
        lambda.orderByDesc(CheckEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            CheckVO resVo = BeanMapper.map(details.get(0), CheckVO.class);
            resVo.setFlag(0);
            return CommonResponse.success("查询详情数据成功！",resVo);
        }else{
            LambdaQueryWrapper<CheckEntity> lambda2 = Wrappers.<CheckEntity>lambdaQuery();
            lambda2.eq(CheckEntity::getTenantId, InvocationInfoProxy.getTenantid());//租户
            lambda2.eq(CheckEntity::getProjectId, projectId);//项目
            lambda2.eq(CheckEntity::getUseState, 1);//已推送
            lambda2.orderByDesc(CheckEntity::getCreateTime);
            details = service.list(lambda2);
            if(CollectionUtils.isNotEmpty(details)){
                CheckVO resVo = BeanMapper.map(details.get(0), CheckVO.class);
                resVo.setFlag(1);
                return CommonResponse.success("查询详情数据成功！", resVo);
            }else{
                return CommonResponse.success("查询详情数据成功！", null);
            }
        }
    }

    /**
     * 查询未引用验收单参照
     * @param projectSourceId     水电八局项目主键
     * @param contractId    水电八局合同主键
     * @param checkDate     验收日期
     * @return
     */
    @RequestMapping(value = "queryCheckRef", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckRestVO>> queryCheckRef(
            @RequestParam(value = "projectSourceId", required=false) String projectSourceId,
            @RequestParam(value = "contractId", required=false) String contractId,
            @RequestParam(value = "checkDate", required=false) String checkDate,
            @RequestParam(value = "checkType", required=false) String checkType) {
        if(StringUtils.isEmpty(projectSourceId)){
            throw new BusinessException("查询验收单参照失败，水电八局项目主键不能为空！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectSourceId", new Parameter(QueryParam.EQ, projectSourceId));
        if(StringUtils.isNotEmpty(contractId)){
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        }
        if(checkDate != null){
            param.getParams().put("checkDate", new Parameter(QueryParam.LE, checkDate));
        }
        if(checkType != null){
            param.getParams().put("checkType", new Parameter(QueryParam.EQ, checkType));
        }
        param.getParams().put("saveState", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("useState", new Parameter(QueryParam.NE, 1));
        param.getOrderMap().put("checkDate", QueryParam.DESC);
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckRestVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<CheckEntity> entityList = page.getRecords();
        List<CheckEntity> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entityList)){
            entityList.forEach(entity -> {
                CheckEntity data = service.selectById(entity.getId());
                list.add(data);
            });
        }
        pageData.setRecords(BeanMapper.mapList(list, CheckRestVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 修改验收单引用状态
     * @param instoreVOList
     * @param
     * @return
     */
    @RequestMapping(value = "updateUseState", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateUseState(@RequestBody List<InstoreVO> instoreVOList) {
        if(CollectionUtils.isNotEmpty(instoreVOList)){
            List<CheckEntity> editlist = new ArrayList<>();
            instoreVOList.forEach(instoreVO -> {
                CheckEntity entity = service.getById(instoreVO.getCheckId());
                if(entity == null){
                    logger.error("修改失败！【" + instoreVO.getCheckId() + "】单据不存在！");
                    return;
                }
                entity.setUseState(instoreVO.getUseState());
                editlist.add(entity);
            });
            if(CollectionUtils.isNotEmpty(editlist)){
                return CommonResponse.success(service.updateBatchById(editlist));
            }
        }
        return CommonResponse.success(true);
    }

    /**
     * 回写入库单数量
     * @param instoreVOList
     * @return
     */
    @RequestMapping(value = "updateInstoreNum", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> updateInstoreNum(@RequestBody List<InstoreVO> instoreVOList) {
        if(CollectionUtils.isNotEmpty(instoreVOList)) {
            List<CheckEntity> editlist = new ArrayList<>();
            instoreVOList.forEach(instoreVO -> {
                CheckEntity entity = service.selectById(instoreVO.getCheckId());
                entity.setInstoreId(instoreVO.getInstoreId());
                editlist.add(entity);
            });
            if(CollectionUtils.isNotEmpty(editlist)){
                service.updateBatchById(editlist);
            }
            instoreVOList.forEach(instoreVO -> {
                List<InstoreDetailVO> vos = instoreVO.getDetailList();
                if(CollectionUtils.isNotEmpty(vos)){
                    List<CheckDetailEntity> list = new ArrayList<>();
                    vos.forEach(vo ->{
                        CheckDetailEntity detail = checkDetailService.getById(vo.getCheckDetailId());
                        BigDecimal instoreNum = detail.getInstoreNum()==null?BigDecimal.ZERO:detail.getInstoreNum();// 入库单数量
                        detail.setInstoreNum(instoreNum.add(vo.getInstoreNum()));
                        detail.setInstoreId(vo.getInstoreId());
                        detail.setInstoreDetailId(vo.getInstoreDetailId());
                        list.add(detail);
                    });
                    if(CollectionUtils.isNotEmpty(list)){
                        checkDetailService.updateBatchById(list);
                    }
                }
            });
        }
        return CommonResponse.success(true);
    }

    /**
     * @Description push2NC NC端推数据
     * @param id
     */
    @RequestMapping(value = "/push2nc", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> push2NC(Long id){
        if(service.push2NC(id)){
            return CommonResponse.success(true);
        }
        return CommonResponse.error("推送失败！");
    }



    /**
     * @Description sysdr 同步删除状态
     * @param id
     */
    @RequestMapping(value = "/sysdr", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> sysdr(Long id){
        return CommonResponse.success(service.sysdr(id));
    }

    /**
     * @Description push2Mro MRO端推数据
     * @param id
     */
    @RequestMapping(value = "/push2Mro", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> push2Mro(Long id){
        if(service.push2Mro(id)){
            return CommonResponse.success(true);
        }
        return CommonResponse.error("推送失败！");
    }

    /**
     * @Description updatenums 更新打印次数
     * @param ids
     */
    @RequestMapping(value = "/updatenums", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> updatenums(@RequestParam("ids") List<Long> ids) {
        if(service.updatenums(ids)){
            return CommonResponse.success(true);
        }
        return CommonResponse.error("更新失败！");
    }

    /**
     * @Description poundList 联查磅单
     * @param id    验收单主键
     */
    @RequestMapping(value = "/poundList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Object> poundList(String id) {
        return service.poundList(id);
    }

    /**
     * @Description poundDetail 查看磅单详情
     * @param pkWeighBill   磅单主键
     */
    @RequestMapping(value = "/poundDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Object> poundDetail(String pkWeighBill) {
        return service.poundDetail(pkWeighBill);
    }

    /**
     * @Description getWeighListByPks 根据主键集合获取磅单信息
     * @param pkWeighBill   磅单主键集合
     */
    @RequestMapping(value = "/getWeighListByPks", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> getWeighListByPks(@RequestBody List<String> pkWeighBill) {
        return service.getWeighListByPks(pkWeighBill);
    }

    /**
     * @Description getWeighListByDelivery 根据发货单主键获取磅单信息
     * @param pkDelivery    发货单主键
     * @param checkStatus   验收状态 0--未验收， 1-已验收  ，不传或者传其他值查询全部
     */
    @RequestMapping(value = "/getWeighListByDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Object> getWeighListByDelivery(@RequestParam("pkDelivery") String pkDelivery,
                @RequestParam(value = "checkStatus", required = false) Integer checkStatus) {
        return service.getWeighListByDelivery(pkDelivery, checkStatus);
    }
    /**
     * 在场周转材参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/materialInRef")
    @ResponseBody
    public CommonResponse<JSONObject> materialInRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                     @RequestParam(value = "condition", required = false) String condition,
                                                     @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        String contractId = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                contractId = conditionMap.get("contractId").toString();
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
        }
        Page<MaterialInRefVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<MaterialInRefVO> list = service.getMaterialInRef(page,wrapper,contractId,InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

}
