package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;

import javax.servlet.http.HttpServletResponse;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 零星用工实体
 *
 * @author generator
 */
@Controller
@RequestMapping("odd")
public class OddController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USE_TYPE_DEF_CODE = "fbxt-use-type";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOddService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOddInfoService oddInfoService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddVO> saveOrUpdate(@RequestBody OddVO saveorUpdateVO) {
        CommonResponse<OddVO> oddVOCommonResponse = service.saveOrUpdate(saveorUpdateVO);
        OddVO data = oddVOCommonResponse.getData();

        // 拆分：将保存saveDetail和查询赋值 拆分为两条事务
        List<OddInfoVO> oddInfoVOList = data.getOddInfoEntities();
        oddInfoVOList.forEach(info -> {
            OddDetailVO redirect = service.queryRedirect(info.getId());
            logger.info("--->> 测试查询清单主键: " + info.getId());
            logger.info("--->> 测试查询转扣结果: " + redirect);
            if (redirect != null && redirect.getZkcontractName() != null) {     // 转扣合同
                info.setZkcontract(redirect.getZkcontractName());
            } else {
                info.setZkcontract("");
            }
            if (redirect != null && redirect.getRedirectcorp() != null) {       // 转扣单位
                info.setZkcorpname(redirect.getRedirectcorp());
            } else {
                info.setZkcorpname("");
            }
            OddInfoEntity oddInfoEntity = BeanMapper.map(info, OddInfoEntity.class);
            oddInfoService.updateById(oddInfoEntity);
        });
        data.setOddInfoEntities(oddInfoVOList);
        return CommonResponse.success("保存或修改单据成功！", data);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddVO> vos) {
        service.del(vos);
        service.removeByIds(vos.stream().map(OddVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("importFlag", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddEntity> page = service.queryPage(param, false);
        IPage<OddVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 查询暂存
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryzcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddVO>> queryzcList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("importFlag", new Parameter(QueryParam.EQ, 0));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage<OddEntity> page = service.queryPage(param, false);
        IPage<OddVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 查询暂存数量
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/getcount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> getcount(@RequestBody QueryParam param) {
        CommonResponse<IPage<OddVO>> response = this.queryzcList(param);
        return CommonResponse.success("查询成功！", response.getData().getTotal());
    }

    /**
     * @param param
     * @Description queryDetailsList 查询零星用工明细
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetailsList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailsList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("cropName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织权限 */
      /*  Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> commonOrgIds = new ArrayList<>();
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }*/

        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        Page<OddDetailVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<OddDetailVO> list = service.queryDetailsList(page, wrapper);
//        list.forEach(detailVO -> {
//            OddDetailVO redirect = service.queryRedirect(detailVO.getId());
//            if (redirect != null && redirect.getZkcontractName() != null) {
//                detailVO.setZkcontractName(redirect.getZkcontractName());
//            } else {
//                detailVO.setZkcontractName("");
//            }
//            if (redirect != null && redirect.getRedirectcorp() != null) {
//                detailVO.setRedirectcorp(redirect.getRedirectcorp());
//            } else {
//                detailVO.setRedirectcorp("");
//            }
//            if (redirect != null && redirect.getZkmny() != null) {
//                detailVO.setZkmny(redirect.getZkmny());
//            } else {
//                detailVO.setZkmny(BigDecimal.ZERO);
//            }
//        });

        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    @RequestMapping(value = "/excelExportDetails", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetails(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> res = this.queryDetailsList(param);
        List<OddDetailVO> list = new ArrayList<>();
        if (res.getData() != null) {
            JSONArray jsonArray = res.getData().getJSONArray("records");
            list = JSONObject.parseArray(jsonArray.toJSONString(), OddDetailVO.class);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                String settleNcFlagName = "";
                if (vo.getSettleNcFlag() != null && vo.getSettleNcFlag() == 1) {
                    settleNcFlagName = "NC已结算";
                } else {
                    settleNcFlagName = "NC未结算";
                }
                vo.setSettleNcFlagName(settleNcFlagName);

                String useTypeName = "";
                if ("1330815360484229121".equals(vo.getUseType())) {
                    useTypeName = "零星用工";
                } else if ("1330815434631135234".equals(vo.getUseType())) {
                    useTypeName = "临时机械";
                } else if ("1330815490885140481".equals(vo.getUseType())) {
                    useTypeName = "变更签证";
                }
                vo.setUseTypeName(useTypeName);

                String belongName = "";
                if ("1330815675283521538".equals(vo.getBelong())) {
                    belongName = "维修";
                } else if ("1330815744443400193".equals(vo.getBelong())) {
                    belongName = "业主原因";
                } else if ("1330815794078793730".equals(vo.getBelong())) {
                    belongName = "临建";
                } else if ("1330815908893671426".equals(vo.getBelong())) {
                    belongName = "合同及设计变更";
                } else if ("1330816008898461698".equals(vo.getBelong())) {
                    belongName = "安全文明施工";
                } else if ("1330816053479718913".equals(vo.getBelong())) {
                    belongName = "其他";
                }
                vo.setBelongName(belongName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState() == null ? 0 : vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("oddDetailsExport.xlsx", beans, response);
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("importFlag", new Parameter(QueryParam.EQ, 0));
        /** 本下 */
        if (param.getParams().get("projectId") == null || param.getParams().get("projectId").getValue() == null) {
            //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");

        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<OddEntity> pageData = service.queryPage(param, false);

        Map<Long, String> queryDefDoc = service.queryDefDoc(USE_TYPE_DEF_CODE);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<OddVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OddVO.class);
            list.forEach(vo -> {
                if (null != vo.getSourceType()) {
                    if (0 == vo.getSourceType()) {
                        vo.setSourceTypeName("参照申请");
                    } else if (1 == vo.getSourceType()) {
                        vo.setSourceTypeName("自制");
                    } else if (2 == vo.getSourceType()) {
                        vo.setSourceTypeName("供方申请");
                    }
                } else {
                    vo.setSourceTypeName("");
                }
                if (null != vo.getSettleNcFlag()) {
                    if (0 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("否");
                    } else if (1 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("是");
                    }
                } else {
                    vo.setSettleNcFlagName("");
                }
                String useTypeName = "";
                if (queryDefDoc.containsKey(vo.getUseType())) {
                    useTypeName = queryDefDoc.get(vo.getUseType());
                }
                vo.setUseTypeName(useTypeName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState() == null ? 0 : vo.getBillState()).getDescription());
                vo.setZkmny(vo.getZkmny() == null ? BigDecimal.ZERO : vo.getZkmny());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("odd-export.xlsx", beans, response);
    }
    /****************  供方相关 start  **************/
    /**
     * 供方插入
     */
    @PostMapping("insert")
    @ResponseBody
    public CommonResponse<Boolean> suplInsert(@RequestBody com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        return CommonResponse.success("供方新增数据成功！", service.suplInsert(request));
    }
    /**
     * 确认
     */
    @PostMapping("confirmSupply")
    @ResponseBody
    public CommonResponse<Boolean> confirmSupply(@RequestBody OddVO request) {
        return CommonResponse.success("确认成功！",service.confirmSupply(request, BillStatusEnum.已确认.getCode()));
    }

    /**
     * 确认驳回
     */
    @PostMapping("rejectSupply")
    @ResponseBody
    public CommonResponse<Boolean> rejectSupply(@RequestBody OddVO request) {
        return CommonResponse.success("驳回成功！",service.confirmSupply(request, BillStatusEnum.确认驳回.getCode()));
    }
    /****************  供方相关 end    **************/
}
