/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.odd.service.IOddImportService;
import com.ejianc.business.fbxt.odd.vo.OddImportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"oddImport"})
public class OddImportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USE_TYPE_DEF_CODE = "fbxt-use-type";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOddImportService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OddImportVO> saveOrUpdate(@RequestBody OddImportVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OddImportVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddImportVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OddImportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("importFlag", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OddImportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"oddImportInfo-import.xlsx", (String)"\u96f6\u661f\u7528\u5de5\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("createName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("createName");
        fuzzyFields.add("cropName");
        param.getParams().put("oddStatus", new Parameter("eq", (Object)1));
        param.getParams().put("importFlag", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("projectId") == null || ((Parameter)param.getParams().get("projectId")).getValue() == null) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage pageData = this.service.queryPage(param, false);
        Map<Long, String> queryDefDoc = this.service.queryDefDoc(USE_TYPE_DEF_CODE);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OddImportVO.class);
            list.forEach(vo -> {
                if (null != vo.getSourceType()) {
                    if (0 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u53c2\u7167\u7533\u8bf7");
                    } else if (1 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u81ea\u5236");
                    } else if (2 == vo.getSourceType()) {
                        vo.setSourceTypeName("\u4f9b\u65b9\u7533\u8bf7");
                    }
                } else {
                    vo.setSourceTypeName("");
                }
                if (null != vo.getSettleNcFlag()) {
                    if (0 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("\u5426");
                    } else if (1 == vo.getSettleNcFlag()) {
                        vo.setSettleNcFlagName("\u662f");
                    }
                } else {
                    vo.setSettleNcFlagName("");
                }
                String useTypeName = "";
                if (queryDefDoc.containsKey(vo.getUseType())) {
                    useTypeName = (String)queryDefDoc.get(vo.getUseType());
                }
                vo.setUseTypeName(useTypeName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)(vo.getBillState() == null ? 0 : vo.getBillState())).getDescription());
                vo.setZkmny(vo.getZkmny() == null ? BigDecimal.ZERO : vo.getZkmny());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("oddImport-export.xlsx", beans, response);
    }
}

