package com.ejianc.business.fbxt.odd.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fbxt.odd.bean.*;
import com.ejianc.business.fbxt.odd.service.IOddImportInfoService;
import com.ejianc.business.fbxt.odd.vo.OddImportInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddImportVO;
import com.ejianc.business.fbxt.util.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fbxt.odd.mapper.OddImportMapper;
import com.ejianc.business.fbxt.odd.service.IOddImportService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 零星用工导入实体
 * 
 * @author generator
 * 
 */
@Service("oddImportService")
public class OddImportServiceImpl extends BaseServiceImpl<OddImportMapper, OddImportEntity> implements IOddImportService{

    private static final String ODD_IMPORT = "HN_ODD_IMPORT";

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOddImportInfoService infoService;

    @Autowired
    private IDefdocApi defdocApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<OddImportVO> saveOrUpdate(OddImportVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddImportEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            // 修改
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = BeanMapper.map(saveorUpdateVO, OddImportEntity.class);
            operateType = "edit";
        } else {
            // 新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ODD_IMPORT, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            saveorUpdateVO.setOddSource(0);
            saveorUpdateVO.setImportFlag(1);
            saveorUpdateVO.setReviewMny(saveorUpdateVO.getUseMny());
            entity = BeanMapper.map(saveorUpdateVO, OddImportEntity.class);
            operateType = "add";
        }

        CommonResponse<OrgVO> orgVo = orgApi.getOneById(entity.getCropId());
        if (!orgVo.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            entity.setCropSourceId(orgVo.getData().getSourceId());
        }

        super.saveOrUpdate(entity,false);

        List<OddImportInfoEntity> infoList = entity.getInfoVOList();  // 获取清单列表实体
        for (OddImportInfoEntity infoEntity : infoList) {
            infoEntity.setOddId(entity.getId());
            infoEntity.setInfoNcFlag(0);
        }

        if (CollectionUtil.isNotEmpty(infoList)) {
            infoService.saveOrUpdateBatch(infoList, infoList.size(), false);
        }

        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    @Override
    public OddImportVO queryDetail(Long id) {
        OddImportEntity entity = this.selectById(id);
        return BeanMapper.map(entity, OddImportVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }

                List<OddImportInfoVO> successList = new ArrayList<>();
                List<OddImportInfoVO> errorList = new ArrayList<>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OddImportInfoVO vo = new OddImportInfoVO();
                    vo.setExcelIndex(i + 2);
                    String warnType = "";
                    boolean flag = false;
                    String name = datas.get(0); // 用工项
                    String code = datas.get(1); // 清单编码
                    String infoUnit = datas.get(2); // 单位
                    String num = datas.get(3); // 数量
                    String price = datas.get(4); // 无税单价
//                    String mny = datas.get(5); // 金额

                    String beginTime = datas.get(5); // 开始时间
                    String endTime = datas.get(6); // 结束时间

                    long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isEmpty(name)) {
                        vo.setName(null);
                        warnType = warnType + "[用工项为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }

                    if (StringUtils.isEmpty(code)) {
                        vo.setCode(null);
                        warnType = warnType + "[清单编码为空]";
                        flag = true;
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(infoUnit)) {
                        vo.setInfoUnit(null);
                        warnType = warnType + "[单位为空]";
                        flag = true;
                    } else {
                        vo.setInfoUnit(infoUnit);
                    }

                    if (StringUtils.isEmpty(num)) {
                        vo.setNum(null);
                        warnType = warnType + "[数量为空]";
                        flag = true;
                    } else {
                        vo.setNum(new BigDecimal(num));
                    }

                    if (StringUtils.isEmpty(price)) {
                        vo.setPrice(null);
                        warnType = warnType + "[数量为空]";
                        flag = true;
                    } else {
                        vo.setPrice(new BigDecimal(price));
                    }

//                    if (StringUtils.isEmpty(mny)) {
//                        vo.setMny(null);
//                        warnType = warnType + "[金额为空]";
//                        flag = true;
//                    } else {
//                        vo.setMny(new BigDecimal(mny));
//                    }

                    String beginDate = null;
                    String endDate = null;
                    try {
                        Double par = Double.parseDouble(beginTime);
                        Date tDate = DoubleToDate(par);
                        beginDate = sdf.format(tDate);

                        vo.setBeginTime(DateUtil.parse(beginDate));
                    } catch (NumberFormatException e) {
                        beginDate = beginTime;
                        warnType = warnType + "[开始时间不是日期格式]";
                        flag = true;
                        logger.info("开始时间不是日期格式");
                    }
                    try {
                        Double par = Double.parseDouble(endTime);
                        Date tDate = DoubleToDate(par);
                        endDate = sdf.format(tDate);

                        vo.setEndTime(DateUtil.parse(endDate));
                    } catch (NumberFormatException e) {
                        endDate = endTime;
                        warnType = warnType + "[结束时间不是日期格式]";
                        flag = true;
                        logger.info("结束时间不是日期格式");
                    }

                    vo.setMny(MathUtil.safeMultiply(vo.getNum(), vo.getPrice()));
                    vo.setSourceType(1);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setRowState("add");

                    if (flag) {
                        vo.setWarnType(warnType.substring(0, warnType.length() - 1));
                        errorList.add(vo);
                    }else {
                        // 校验时间
                        if (DateUtil.parse(beginDate).compareTo(DateUtil.parseDate(endDate)) > 0) {
                            vo.setWarnType("计划开始日期大于父级计划开始日期");
                            errorList.add(vo);
                        }else {
                            successList.add(vo);
                        }
                    }
                }

                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }

    }

    @Override
    public Map<Long, String> queryDefDoc(String useTypeDefCode) {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = defdocApi.queryDetailListByDefdocCode(useTypeDefCode, null);
        if (listCommonResponse.isSuccess()) {
            List<Map<String, Object>> data = listCommonResponse.getData();
            Map<Long, String> docMap = new HashMap<>();
            for (Map<String, Object> map : data) {
                docMap.put(Long.parseLong(map.get("id").toString()), map.get("name").toString());
            }
            return docMap;
        } else {
            throw new BusinessException("查询自定义档案失败!");
        }
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));

        return tDate;
    }

}
