package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.ZjwjHnWzxtSyncHystrix;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.business.wzxt.vo.sync.SyncCtPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncCtPlanVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "cscec5bhn-wzxt-web", url="${common.env.feign-client-url}", path="cscec5bhn-wzxt-web", fallback = ZjwjHnWzxtSyncHystrix.class)
public interface IZjwjHnWzxtSyncApi {


	/**
	 * 总控计划表头
	 *
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanList")
	CommonResponse<String> syncControlPlanList(@RequestBody  List<SyncControlPlanVO> controlPlanVOS);


	/**
	 * 总控计划表体
	 *
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanDetailList")
	CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS);

	/**
	 * 消耗材总控计划表头
	 *
	 * @param ctPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanList")
	CommonResponse<String> syncCtPlanList(@RequestBody  List<SyncCtPlanVO> ctPlanVOS);


	/**
	 * 消耗材总控计划表体
	 *
	 * @param ctPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanDetailList")
	CommonResponse<String> syncCtPlanDetailList(@RequestBody List<SyncCtPlanDetailVO> ctPlanDetailVOS);

	/**
	 * 同步MRO项目
	 *
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMroProjectList")
	CommonResponse<String> syncMroProjectList();

	/**
	 * 同步MRO送货单
	 *
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMroDeliveryList")
	CommonResponse<String> syncMroDeliveryList();


	/**
	 * 总控计划表头
	 *
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanListHn")
	CommonResponse<String> syncControlPlanListHn(@RequestBody  List<ControlPlanHnVO> controlPlanVOS);


	/**
	 * 总控计划表体
	 *
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanDetailListHn")
	CommonResponse<String> syncControlPlanDetailListHn(@RequestBody List<ControlPlanDetailHnVO> controlPlanDetailVOS);

	/**
	 * 消耗材总控计划表头
	 *
	 * @param ctPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanListHn")
	CommonResponse<String> syncCtPlanListHn(@RequestBody  List<CtPlanHnVO> ctPlanVOS);


	/**
	 * 消耗材总控计划表体
	 *
	 * @param ctPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncCtPlanDetailListHn")
	CommonResponse<String> syncCtPlanDetailListHn(@RequestBody List<CtPlanDetailHnVO> ctPlanDetailVOS);

}
