package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.ProjectConfigureHnHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取订单内所有项目方法
 *
 * @author yqls
 *
 */
@FeignClient(name= "cscec5b-wzxt-web", url="${common.env.feign-client-url}", path="cscec5b-wzxt-web", fallback = ProjectConfigureHnHystrix.class)
public interface IProjectConfigureHnApi {

	/**
	 * 校验MRO项目ID+项目ID唯一
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/projectConfigure/check")
	CommonResponse<String> check(@RequestParam(value = "projectId", required = false) Long projectId,
                                 @RequestParam(value = "mroProjectId", required = false) Long mroProjectId);

}
