package com.ejianc.business.wzxt.util;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("checkImg")
public class DealWJImageController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DealWJImageMapper mapper;

    public static int Guid=100;

    /**
     * @Description
     */
    @RequestMapping(value = "/dealWJImage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> dealWJImage() {
        Map<Long, Check> map = mapper.getCheckMap();
        List<AttachmentVO> list = new ArrayList<>();
        for(Long key : map.keySet()){
            Check check = map.get(key);
            String tpurl = check.getTpurl();
            if(StringUtils.isNotEmpty(tpurl)){
                String[] tpurls = tpurl.split(",");
                for(String url : tpurls){
                    String filePath = "qjhistory/" + url;
                    AttachmentVO vo = new AttachmentVO();
                    vo.setId(Long.valueOf(this.getGuid()));
                    vo.setSourceId(map.get(key).getId());
                    vo.setFileName("图片" + filePath.substring(filePath.lastIndexOf(".")));
                    vo.setFilePath(filePath);
                    vo.setFileSize(Long.valueOf("10123"));
                    vo.setBillType("BT210816000000002");
                    vo.setSourceType("imgUpload1");
                    vo.setUploadUserName("系统管理员");
//                    vo.setSyncEsFlag("0");
                    vo.setTenantId(Long.valueOf("999999"));
                    vo.setCreateUserCode("guoming");
                    vo.setCreateTime(new Date());
                    List<Map<String, String>> fileFormatPath = new ArrayList<>();
                    Map<String, String> pathMap = new HashMap<>(10);
                    pathMap.put("filePath0", filePath+"?x-oss-process=image/resize,m_fixed,h_120,w_120");
                    fileFormatPath.add(pathMap);
                    vo.setFileFormatPath(fileFormatPath);
                    vo.setFileFormatPathStr(JSONArray.toJSONString(fileFormatPath));
                    list.add(vo);
                }
            }

            String sceneurl = check.getSceneurl();
            if(StringUtils.isNotEmpty(sceneurl)){
                String[] sceneurls = sceneurl.split(",");
                for(String url : sceneurls){
                    String filePath = "qjhistory/" + url;
                    AttachmentVO vo = new AttachmentVO();
                    vo.setId(Long.valueOf(this.getGuid()));
                    vo.setSourceId(map.get(key).getId());
                    vo.setFileName("图片" + filePath.substring(filePath.lastIndexOf(".")));
                    vo.setFilePath(filePath);
                    vo.setFileSize(Long.valueOf("10123"));
                    vo.setBillType("BT210816000000002");
                    vo.setSourceType("imgUpload2");
                    vo.setUploadUserName("系统管理员");
//                    vo.setSyncEsFlag("0");
                    vo.setTenantId(Long.valueOf("999999"));
                    vo.setCreateUserCode("guoming");
                    vo.setCreateTime(new Date());
                    List<Map<String, String>> fileFormatPath = new ArrayList<>();
                    Map<String, String> pathMap = new HashMap<>(10);
                    pathMap.put("filePath0", filePath+"?x-oss-process=image/resize,m_fixed,h_120,w_120");
                    fileFormatPath.add(pathMap);
                    vo.setFileFormatPath(fileFormatPath);
                    vo.setFileFormatPathStr(JSONArray.toJSONString(fileFormatPath));
                    list.add(vo);
                }
            }
        }
        mapper.insertAttachmentVO(list);
//        System.out.println(JSONObject.toJSONString(list));
        return CommonResponse.success("查询成功！","ok");
    }

    public static String getGuid() {
        Guid+=1;
        long now = System.currentTimeMillis();
        //获取4位年份数字
        SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy");
        //获取时间戳
        String time=dateFormat.format(now);
        String info=now+"";
        //获取三位随机数
//        int ran=(int) ((Math.random()*9+1)*100);
        //要是一段时间内的数据连过大会有重复的情况，所以做以下修改
        int ran=0;
        if(Guid>999){
            Guid=100;
        }
        ran = Guid;
        return time+info.substring(2, info.length())+ran;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; i++){
//            System.out.println(DealWJImageController.getUUIDInOrderId());
            long now = System.currentTimeMillis();
            System.out.println(now);
        }
    }

}
