/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.api;

import com.ejianc.business.voucher.service.VoucherBusinessService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voucherApi/"})
public class VoucherApi {
    @Autowired
    private VoucherBusinessService voucherBusinessService;

    @PostMapping(value={"save"})
    public CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams) {
        Assert.notNull((Object)voucherParams.getBillTypeCode(), (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)voucherParams.getBillData(), (String)"\u5355\u636e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Boolean isGenerateVoucher = this.voucherBusinessService.isGenerateVoucher(voucherParams);
        if (!isGenerateVoucher.booleanValue()) {
            VoucherInfo noNeedVoucherInfo = VoucherInfo.getNoNeedVoucherInfo();
            return CommonResponse.success((Object)noNeedVoucherInfo);
        }
        CommonResponse<VoucherInfo> response = this.voucherBusinessService.save(voucherParams);
        if (response.isSuccess() && response.getData() != null) {
            VoucherInfo data = (VoucherInfo)response.getData();
            data.setSystemCode(voucherParams.getSystemCode());
            data.setBillTypeCode(voucherParams.getBillTypeCode());
        }
        return response;
    }

    @PostMapping(value={"get"})
    public CommonResponse<Map<String, Object>> get(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.get(voucherInfo);
    }

    @PostMapping(value={"del"})
    public CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.del(voucherInfo);
    }

    @RequestMapping(value={"isGenerateVoucher"}, method={RequestMethod.GET})
    public CommonResponse<Boolean> isGenerateVoucher(@RequestParam(value="billTypeCode") String billTypeCode) {
        return CommonResponse.success((Object)Boolean.TRUE);
    }
}

