/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.service.VoucherParamsBuilder;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.OriginVoucher;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherBusinessService {
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private VoucherParamsBuilder voucherParamsBuilder;

    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        this.voucherParamsBuilder.buildVoucherParams(voucherParams);
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue()) {
            OriginVoucher originVoucher = voucherParams.getOriginVoucher();
        }
        if (voucherParams.getIsGenerateFinanceVoucherFlag().booleanValue()) {
            String systemCode = voucherParams.getSystemCode();
            return this.getFinanceVoucherService(systemCode).save(voucherParams.getFinanceVoucher());
        }
        return CommonResponse.success();
    }

    public CommonResponse<Map<String, Object>> get(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getSystemCode()).get(voucherInfo);
    }

    public CommonResponse del(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getSystemCode()).del(voucherInfo);
    }

    public Boolean isGenerateVoucher(VoucherParams voucherParams) {
        return Boolean.FALSE;
    }

    private IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        return this.voucherServiceFactory.getFinanceVoucherService(systemCode);
    }
}

