/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.transfer;

import com.ejianc.business.accplat.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.service.VoucherTemplateCacheProvider;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseVoucherTransferService {
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private VoucherTemplateCacheProvider voucherTemplateCacheProvider;

    public void transfer(VoucherParams voucherParams) {
        voucherParams.setIsGenerateOriginVoucherFlag(this.getIsGenerateOriginVoucherFlag(voucherParams));
        voucherParams.setIsGenerateFinanceVoucherFlag(this.getIsGenerateFinanceVoucherFlag(voucherParams));
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue()) {
            this.transferOriginVoucher(voucherParams);
        }
        if (voucherParams.getIsGenerateFinanceVoucherFlag().booleanValue()) {
            this.transferFinanceVoucher(voucherParams);
        }
    }

    public abstract void transferOriginVoucher(VoucherParams var1);

    public abstract void transferFinanceVoucher(VoucherParams var1);

    public void transferOriginVoucherByVoucherTemplate(VoucherParams voucherParams) {
        VoucherTemplateVO voucherTemplateVO = this.voucherTemplateCacheProvider.loadTemplateFromCache(InvocationInfoProxy.getTenantid(), voucherParams.getBillTypeCode());
        voucherParams.setOriginVoucher(null);
    }

    public void transferFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        String systemCode = voucherParams.getSystemCode();
        IFinanceVoucherService financeVoucherService = this.voucherServiceFactory.getFinanceVoucherService(systemCode);
        financeVoucherService.convertToFinanceVoucherByOriginVoucher(voucherParams);
    }

    public Boolean getIsGenerateOriginVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }

    public Boolean getIsGenerateFinanceVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }
}

