/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.properties;

import com.ejianc.business.yonyou.base.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public interface URLProperties {
    public static final char URL_SPLIT_CHAT = '/';

    default public Set<String> parseCommaSplitParam(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return Collections.emptySet();
        }
        String[] split = source.split(",");
        return Stream.of(split).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    default public StringBuilder concatUrl(String urlPrefix, String ... urlFragment) {
        if (urlPrefix == null) {
            throw new BusinessException("invalid url prefix, can not be null");
        }
        StringBuilder builder = new StringBuilder(urlPrefix);
        for (String fragment : urlFragment) {
            this.concatURLFragment(builder, fragment);
        }
        return builder;
    }

    default public String concatParam(String path, String paramUrl) {
        if (path.indexOf(63) == -1) {
            if (paramUrl.indexOf(63) == -1) {
                return path + "?" + paramUrl;
            }
            return path + paramUrl;
        }
        if (paramUrl.startsWith("&")) {
            if (path.endsWith("&")) {
                return path.substring(0, path.length() - 1) + paramUrl;
            }
            return path + paramUrl;
        }
        if (path.endsWith("&")) {
            return path + paramUrl;
        }
        return path + "&" + paramUrl;
    }

    default public String concatURL(String urlPrefix, String ... urlFragment) {
        return this.concatUrl(urlPrefix, urlFragment).toString();
    }

    default public void concatURLFragment(StringBuilder builder, String fragment) {
        if (StringUtils.isBlank((CharSequence)fragment)) {
            return;
        }
        if (fragment.length() == 1 && fragment.charAt(0) == '/') {
            return;
        }
        String trimFragment = fragment.trim();
        if (builder.indexOf("?") != -1) {
            builder.append(trimFragment);
            return;
        }
        if (trimFragment.startsWith("?")) {
            builder.append(trimFragment);
            return;
        }
        this.concatPaths(builder, trimFragment);
    }

    default public void concatPaths(StringBuilder builder, String trimFragment) {
        char c1 = builder.charAt(builder.length() - 1);
        char c2 = trimFragment.charAt(0);
        if (c1 == '/' && c2 == '/') {
            builder.append(trimFragment.substring(1));
            return;
        }
        if (c1 == '/' || c2 == '/') {
            builder.append(trimFragment);
            return;
        }
        builder.append('/').append(trimFragment);
    }

    default public String buildQueryString(Map<String, String> params, boolean doUrlEncode) {
        StringBuilder builder = new StringBuilder();
        params.forEach((k, v) -> {
            if (StringUtils.isNotBlank((CharSequence)v)) {
                builder.append((String)k).append('=');
                if (doUrlEncode) {
                    try {
                        builder.append(URLEncoder.encode(v, StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    builder.append((String)v);
                }
                builder.append("&");
            }
        });
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

