/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.ejianc.business.accplat.vo.VoucherTemplateVO;
import com.ejianc.framework.cache.redis.CacheManager;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherTemplateCacheProvider {
    private final String VOUCHER_TEMPLATE_CACHE_PREFIX = "ejcvouchertemplate:";
    @Autowired
    private CacheManager cacheManager;

    public VoucherTemplateVO loadTemplateFromCache(Long tenantId, String billTypeCode) {
        String cacheKey = this.getCacheKey(tenantId, billTypeCode);
        VoucherTemplateVO voucherTemplateVO = (VoucherTemplateVO)this.cacheManager.get(cacheKey);
        if (null == voucherTemplateVO) {
            voucherTemplateVO = null;
            this.saveTemplateToCache(cacheKey, voucherTemplateVO);
        }
        return voucherTemplateVO;
    }

    public void saveTemplateToCache(String cacheKey, VoucherTemplateVO voucherTemplateVO) {
        this.cacheManager.set(cacheKey, (Serializable)voucherTemplateVO);
    }

    public void removeTemplateCache(Long tenantId, String billTypeCode) {
        String cacheKey = this.getCacheKey(tenantId, billTypeCode);
        if (this.cacheManager.exists(cacheKey).booleanValue()) {
            this.cacheManager.removeCache(cacheKey);
        }
    }

    private String getCacheKey(Long tenantId, String billTypeCode) {
        return "ejcvouchertemplate:" + billTypeCode + tenantId;
    }
}

