package com.ejianc.business.accplat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 科目对照
 * 
 * @author generator
 * 
 */
 @TableName("ejc_accplat_subject_contrast")
public class SubjectContrastEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="subject_chart_id")
    private Long subjectChartId; // 科目表ID
    @TableField(value="subject_chart_code")
    private String subjectChartCode; // 科目表编码
    @TableField(value="subject_chart_name")
    private String subjectChartName; // 科目表名称
    @TableField(value="subject_category_code")
    private String subjectCategoryCode; // 科目分类编码
    @TableField(value="subject_category_name")
    private String subjectCategoryName; // 科目分类名称
    @TableField(value="default_subject_id")
    private Long defaultSubjectId; // 默认入账科目ID
    @TableField(value="default_subject_code")
    private String defaultSubjectCode; // 默认入账科目编码
    @TableField(value="default_subject_name")
    private String defaultSubjectName; // 默认入账科目名称
    @TableField(value="influence_ids")
    private String influenceIds; // 影响因素ids
    @TableField(value="influence_names")
    private String influenceNames; // 影响因素names
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="subjectContrastDetailService", pidName = "contrastId")
    private List<SubjectContrastDetailEntity> subjectContrastDetailList = new ArrayList<>(); // 科目对照-对照明细


    public Long getSubjectChartId() {
        return subjectChartId;
    }

    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }
    public String getSubjectChartCode() {
        return subjectChartCode;
    }

    public void setSubjectChartCode(String subjectChartCode) {
        this.subjectChartCode = subjectChartCode;
    }
    public String getSubjectChartName() {
        return subjectChartName;
    }

    public void setSubjectChartName(String subjectChartName) {
        this.subjectChartName = subjectChartName;
    }
    public String getSubjectCategoryCode() {
        return subjectCategoryCode;
    }

    public void setSubjectCategoryCode(String subjectCategoryCode) {
        this.subjectCategoryCode = subjectCategoryCode;
    }
    public String getSubjectCategoryName() {
        return subjectCategoryName;
    }

    public void setSubjectCategoryName(String subjectCategoryName) {
        this.subjectCategoryName = subjectCategoryName;
    }
    public Long getDefaultSubjectId() {
        return defaultSubjectId;
    }

    public void setDefaultSubjectId(Long defaultSubjectId) {
        this.defaultSubjectId = defaultSubjectId;
    }
    public String getDefaultSubjectCode() {
        return defaultSubjectCode;
    }

    public void setDefaultSubjectCode(String defaultSubjectCode) {
        this.defaultSubjectCode = defaultSubjectCode;
    }
    public String getDefaultSubjectName() {
        return defaultSubjectName;
    }

    public void setDefaultSubjectName(String defaultSubjectName) {
        this.defaultSubjectName = defaultSubjectName;
    }
    public String getInfluenceIds() {
        return influenceIds;
    }

    public void setInfluenceIds(String influenceIds) {
        this.influenceIds = influenceIds;
    }
    public String getInfluenceNames() {
        return influenceNames;
    }

    public void setInfluenceNames(String influenceNames) {
        this.influenceNames = influenceNames;
    }
    
    public List<SubjectContrastDetailEntity> getSubjectContrastDetailList() {
        return subjectContrastDetailList;
    }

    public void setSubjectContrastDetailList(List<SubjectContrastDetailEntity> subjectContrastDetailList) {
        this.subjectContrastDetailList = subjectContrastDetailList;
    }
}
