package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.bean.BillAuxiliarySetEntity;
import com.ejianc.business.accplat.service.IBillAuxiliarySetService;
import com.ejianc.business.accplat.vo.BillAuxiliarySetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 会计平台设置-辅助核算项关联
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billAuxiliarySet")
@Api(value = "会计平台设置-辅助核算项关联", tags = {"会计平台设置-辅助核算项关联"})
public class BillAuxiliarySetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillAuxiliarySetService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillAuxiliarySetVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BillAuxiliarySetVO saveOrUpdateVO) {
        BillAuxiliarySetEntity entity = BeanMapper.map(saveOrUpdateVO, BillAuxiliarySetEntity.class);
        service.saveOrUpdate(entity, false);
        BillAuxiliarySetVO vo = BeanMapper.map(entity, BillAuxiliarySetVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillAuxiliarySetVO> queryDetail(@RequestParam Long id) {
        BillAuxiliarySetEntity entity = service.selectById(id);
        BillAuxiliarySetVO vo = BeanMapper.map(entity, BillAuxiliarySetVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillAuxiliarySetVO> vos) {
        service.removeByIds(vos.stream().map(BillAuxiliarySetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillAuxiliarySetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BillAuxiliarySetEntity> page = service.queryPage(param, false);
        IPage<BillAuxiliarySetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillAuxiliarySetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BillAuxiliarySetEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BIllAuxiliarySet-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBIllAuxiliarySetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BillAuxiliarySetVO>> refBIllAuxiliarySetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BillAuxiliarySetEntity> page = service.queryPage(param, false);
        IPage<BillAuxiliarySetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillAuxiliarySetVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
