package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.bean.SubjectChartEntity;
import com.ejianc.business.accplat.service.ISubjectChartService;
import com.ejianc.business.accplat.vo.SubjectChartVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科目表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subjectChart")
@Api(value = "科目表", tags = {"科目表"})
public class SubjectChartController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubjectChartService service;

    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String SUBJECT_CHART_CODE = "SUBJECT_CHART_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectChartVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody SubjectChartVO saveOrUpdateVO) {
        String code = saveOrUpdateVO.getCode();
        if (StringUtils.isBlank(code)) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUBJECT_CHART_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaQueryWrapper<SubjectChartEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SubjectChartEntity::getCode, saveOrUpdateVO.getCode());
            wrapper.ne(saveOrUpdateVO.getId() != null, SubjectChartEntity::getId, saveOrUpdateVO.getId());
            int count = service.count(wrapper);
            if (count > 0) {
                throw new BusinessException("编码已存在！");
            }
        }

        SubjectChartEntity entity = BeanMapper.map(saveOrUpdateVO, SubjectChartEntity.class);
        service.saveOrUpdate(entity, false);
        SubjectChartVO vo = BeanMapper.map(entity, SubjectChartVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectChartVO> queryDetail(@RequestParam Long id) {
        SubjectChartEntity entity = service.selectById(id);
        SubjectChartVO vo = BeanMapper.map(entity, SubjectChartVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectChartVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubjectChartVO vo : vos) {
                CommonResponse<String> resp = billTypeApi.checkQuote("BT202312000003", vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(SubjectChartVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SubjectChartVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("sequence", "asc");
        param.setOrderMap(orderMap);
        List<SubjectChartEntity> subjectChartEntities = service.queryList(param, false);
        List<SubjectChartVO> subjectChartVOS = BeanMapper.mapList(subjectChartEntities, SubjectChartVO.class);
        return CommonResponse.success("查询列表数据成功！", subjectChartVOS);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        fuzzyFields.addAll(Arrays.asList("code", "name"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SubjectChartEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectChart-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubjectChartData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubjectChartVO>> refSubjectChartData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubjectChartEntity> page = service.queryPage(param, false);
        IPage<SubjectChartVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectChartVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
