package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.bean.InfluenceEntity;
import com.ejianc.business.accplat.bean.SubjectContrastDetailInfluenceEntity;
import com.ejianc.business.accplat.bean.SubjectContrastEntity;
import com.ejianc.business.accplat.service.IInfluenceService;
import com.ejianc.business.accplat.service.ISubjectContrastDetailInfluenceService;
import com.ejianc.business.accplat.service.ISubjectContrastService;
import com.ejianc.business.accplat.vo.InfluenceVO;
import com.ejianc.business.accplat.vo.SubjectContrastVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 科目对照
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subjectContrast")
@Api(value = "科目对照", tags = {"科目对照"})
public class SubjectContrastController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISubjectContrastService service;

    @Autowired
    private IInfluenceService influenceService;

    @Autowired
    private ISubjectContrastDetailInfluenceService detailInfluenceService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectContrastVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody SubjectContrastVO saveOrUpdateVO) {
        LambdaQueryWrapper<SubjectContrastEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SubjectContrastEntity::getSubjectCategoryCode, saveOrUpdateVO.getSubjectCategoryCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, SubjectContrastEntity::getId, saveOrUpdateVO.getId());
        int count = service.count(wrapper);
        if (count > 0) {
            throw new BusinessException("科目分类编码已存在！");
        }

        SubjectContrastEntity entity = BeanMapper.map(saveOrUpdateVO, SubjectContrastEntity.class);
        service.insertOrUpdate(entity);
        SubjectContrastVO vo = BeanMapper.map(entity, SubjectContrastVO.class);
        String influenceIds = vo.getInfluenceIds();
        if (StringUtils.isNotBlank(influenceIds)) {
            LambdaQueryWrapper<InfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            influenceEntityLambdaQueryWrapper.in(InfluenceEntity::getId, influenceIds.split(","));
            List<InfluenceEntity> influenceEntities = influenceService.list(influenceEntityLambdaQueryWrapper);
            vo.setSelectedInfluence(BeanMapper.mapList(influenceEntities, InfluenceVO.class));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectContrastVO> queryDetail(@RequestParam Long id) {
        SubjectContrastEntity entity = service.selectById(id);
        if (ListUtil.isNotEmpty(entity.getSubjectContrastDetailList())) {
            entity.getSubjectContrastDetailList().forEach(detail -> {
                LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, detail.getId());
                List<SubjectContrastDetailInfluenceEntity> influenceEntities = detailInfluenceService.list(influenceEntityLambdaQueryWrapper);
                detail.setSubjectContrastDetailInfluenceList(influenceEntities);
            });
        }
        SubjectContrastVO vo = BeanMapper.map(entity, SubjectContrastVO.class);
        String influenceIds = vo.getInfluenceIds();
        if (StringUtils.isNotBlank(influenceIds)) {
            LambdaQueryWrapper<InfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            influenceEntityLambdaQueryWrapper.in(InfluenceEntity::getId, influenceIds.split(","));
            List<InfluenceEntity> influenceEntities = influenceService.list(influenceEntityLambdaQueryWrapper);
            vo.setSelectedInfluence(BeanMapper.mapList(influenceEntities, InfluenceVO.class));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectContrastVO> vos) {
        List<Long> contrastIds = vos.stream().map(SubjectContrastVO::getId).collect(Collectors.toList());
        service.removeByIds(contrastIds, true);
        LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaDelWrapper = new LambdaQueryWrapper<>();
        influenceEntityLambdaDelWrapper.in(SubjectContrastDetailInfluenceEntity::getContrastId, contrastIds);
        detailInfluenceService.remove(influenceEntityLambdaDelWrapper);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubjectContrastVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCategoryCode", "subjectCategoryName", "influenceNames", "defaultSubjectCode", "defaultSubjectName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SubjectContrastEntity> page = service.queryPage(param, false);
        IPage<SubjectContrastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectContrastVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCategoryCode", "subjectCategoryName", "influenceNames", "defaultSubjectCode", "defaultSubjectName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SubjectContrastEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectContrast-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubjectContrastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubjectContrastVO>> refSubjectContrastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubjectContrastEntity> page = service.queryPage(param, false);
        IPage<SubjectContrastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectContrastVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
