package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.bean.AuxiliaryEntity;
import com.ejianc.business.accplat.bean.SubjectChartEntity;
import com.ejianc.business.accplat.bean.SubjectEntity;
import com.ejianc.business.accplat.service.IAuxiliaryService;
import com.ejianc.business.accplat.service.ISubjectChartService;
import com.ejianc.business.accplat.service.ISubjectService;
import com.ejianc.business.accplat.vo.SubjectAuxiliaryVO;
import com.ejianc.business.accplat.vo.SubjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 会计科目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subject")
@Api(value = "会计科目", tags = {"会计科目"})
public class SubjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubjectChartService subjectChartService;

    @Autowired
    private ISubjectService service;

    @Autowired
    private IAuxiliaryService auxiliaryService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody SubjectVO saveOrUpdateVO) {
        LambdaQueryWrapper<SubjectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SubjectEntity::getSubjectCode, saveOrUpdateVO.getSubjectCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, SubjectEntity::getId, saveOrUpdateVO.getId());
        int count = service.count(wrapper);
        if (count > 0) {
            throw new BusinessException("编码已存在！");
        }

        List<SubjectAuxiliaryVO> subjectAuxiliaryList = saveOrUpdateVO.getSubjectAuxiliaryList();
        String auxiliaryIds = null;
        String auxiliaryNames = null;
        if (CollectionUtils.isNotEmpty(subjectAuxiliaryList)) {
            auxiliaryIds = subjectAuxiliaryList.stream().filter(t -> !"del".equals(t.getRowState())).map(t -> String.valueOf(t.getAuxiliaryId())).collect(Collectors.joining(","));
            auxiliaryNames = subjectAuxiliaryList.stream().filter(t -> !"del".equals(t.getRowState())).map(SubjectAuxiliaryVO::getAuxiliaryName).collect(Collectors.joining(","));
        }
        saveOrUpdateVO.setAuxiliaryIds(auxiliaryIds);
        saveOrUpdateVO.setAuxiliaryNames(auxiliaryNames);

        Long parentId = saveOrUpdateVO.getParentId();
        long id = IdWorker.getId();
        saveOrUpdateVO.setId(id);
        if (parentId == null) {
            saveOrUpdateVO.setInnerCode(String.valueOf(id));
            if (saveOrUpdateVO.getSubjectChartId() == null) {
                throw new BusinessException("科目表ID[subjectChartId]不能为空");
            }
        } else {
            SubjectEntity parent = service.getById(parentId);
            saveOrUpdateVO.setInnerCode(parent.getInnerCode() + "|" + id);
            saveOrUpdateVO.setSubjectChartId(parent.getSubjectChartId());
        }
        SubjectEntity entity = BeanMapper.map(saveOrUpdateVO, SubjectEntity.class);
        service.saveOrUpdate(entity, false);
        SubjectVO vo = BeanMapper.map(entity, SubjectVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectVO> queryDetail(@RequestParam Long id) {
        SubjectEntity entity = service.selectById(id);
        SubjectVO vo = BeanMapper.map(entity, SubjectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectVO> vos) {
        service.removeByIds(vos.stream().map(SubjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<SubjectEntity> subjectEntities = service.queryList(param, false);
        List<SubjectVO> subjectVOS = BeanMapper.mapList(subjectEntities, SubjectVO.class);
        List<Map> resultMapList = BeanMapper.mapList(subjectVOS, Map.class);
        return CommonResponse.success("查询列表数据成功！", ResultAsTree.createTreeData(resultMapList));
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SubjectEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subject-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubjectData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refSubjectData(String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        List<SubjectEntity> subjectEntities = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (SubjectEntity entity : subjectEntities) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Subject-import.xlsx", "导入会计科目");
    }


    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport/{subjectChartId}", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(@PathVariable(name = "subjectChartId") Long subjectChartId, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            SubjectChartEntity subjectChartEntity = subjectChartService.getById(subjectChartId);
            Integer subjectCodeType = subjectChartEntity.getSubjectCodeType();
            String subjectCodeRule = subjectChartEntity.getSubjectCodeRule().trim();
            Map<Integer, Integer> selfRuleMap = new HashMap<>();
            if (subjectCodeType.intValue() == 2) {
                String[] ruleNum = subjectCodeRule.split("-");
                for (String s : ruleNum) {
                    int sum = selfRuleMap.values().stream().mapToInt(Integer::intValue).sum();
                    selfRuleMap.put(Integer.valueOf(s), sum);
                }
            }

            List<List<String>> result = ExcelReader.readExcel(mf);
            List<SubjectVO> successList = new ArrayList<>();
            List<SubjectVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 4) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            Map<String, Integer> codeMap = new HashMap<>();
            Map<String, SubjectVO> parentMap = new HashMap<>();
            for (int i = 0; i < result.size(); i++) {
                //当前行号
                int rowNum = i + 2;
                // 开始判断逻辑
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                StringBuilder errorFlag = new StringBuilder(); //1可忽略的错误、2不可忽略错误
                if (row.get(1) == null) {
                    continue;
                }
                SubjectVO subjectVO = new SubjectVO();
                subjectVO.setSubjectChartId(subjectChartId);
                // 编号
                String subjectCode = row.get(0).trim();
                if (StringUtils.isNotBlank(subjectCode)) {
                    subjectVO.setSubjectCode(subjectCode);
                    if (!codeMap.containsKey(subjectCode)) {
                        LambdaQueryWrapper<SubjectEntity> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(SubjectEntity::getSubjectCode, subjectCode);
                        wrapper.eq(SubjectEntity::getTenantId, InvocationInfoProxy.getTenantid());
                        SubjectEntity one = service.getOne(wrapper);
                        if (one != null) {
                            BeanUtils.copyProperties(one, subjectVO, "parentId", "innerCode", "subjectChartId", "treeIndex", "subjectCode", "subjectName", "fullName", "auxiliaryIds", "auxiliaryNames");
                            errMsg.append("`第" + rowNum + "行科目编码已存在、可覆盖更新`");
                            errorFlag.append("1");
                        }
                        codeMap.put(subjectCode, rowNum);
                    } else {
                        errorFlag.append("2");
                        errMsg.append("`第" + codeMap.get(subjectCode) + "、" + rowNum + "行科目编码重复`");
                    }
                } else {
                    errorFlag.append("2");
                    errMsg.append("`科目编码未填写`");
                }

                // 科目名称
                String subjectName = row.get(1).trim();
                if (StringUtils.isNotBlank(subjectName)) {
                    subjectVO.setSubjectName(subjectName);
                } else {
                    errorFlag.append("2");
                    errMsg.append("`科目名称未填写`");
                }
                // 全名
                String fullName = row.get(2).trim();
                if (StringUtils.isNotBlank(fullName)) {
                    subjectVO.setFullName(fullName);
                } else {
                    errorFlag.append("2");
                    errMsg.append("`全名未填写`");
                }
                // 辅助核算项
                String auxiliaryNamesStr = row.get(3).trim();
                if (StringUtils.isNotBlank(auxiliaryNamesStr)) {
                    subjectVO.setAuxiliaryNames(auxiliaryNamesStr);
                    String[] auxiliaryNameArr = auxiliaryNamesStr.split("[,，]");
                    List<String> auxiliaryNames = Arrays.asList(auxiliaryNameArr).stream().distinct().collect(Collectors.toList());
                    LambdaQueryWrapper<AuxiliaryEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.in(AuxiliaryEntity::getAuxiliaryName, auxiliaryNames);
                    wrapper.eq(AuxiliaryEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    List<AuxiliaryEntity> list = auxiliaryService.list(wrapper);
                    Map<String, AuxiliaryEntity> auxiliaryMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(list)) {
                        auxiliaryMap = list.stream().collect(Collectors.toMap(AuxiliaryEntity::getAuxiliaryName, t -> t));
                    }
                    List<SubjectAuxiliaryVO> subjectAuxiliaryVOS = new ArrayList<>();
                    for (String auxiliaryName : auxiliaryNames) {
                        AuxiliaryEntity auxiliaryEntity = auxiliaryMap.get(auxiliaryName);
                        if (auxiliaryEntity != null) {
                            SubjectAuxiliaryVO subjectAuxiliaryVO = new SubjectAuxiliaryVO();
                            subjectAuxiliaryVO.setAuxiliaryId(auxiliaryEntity.getId());
                            subjectAuxiliaryVO.setAuxiliaryCode(auxiliaryEntity.getAuxiliaryCode());
                            subjectAuxiliaryVO.setAuxiliaryName(auxiliaryEntity.getAuxiliaryName());
                            subjectAuxiliaryVO.setDataType(auxiliaryEntity.getDataType());
                            subjectAuxiliaryVO.setReferId(auxiliaryEntity.getReferId());
                            subjectAuxiliaryVO.setReferCode(auxiliaryEntity.getReferCode());
                            subjectAuxiliaryVO.setReferName(auxiliaryEntity.getReferName());
                            subjectAuxiliaryVO.setSubjectId(subjectVO.getId());
                            subjectAuxiliaryVOS.add(subjectAuxiliaryVO);
                        } else {
                            errMsg.append("`辅助核算项[" + auxiliaryName + "]不存在、可忽略导入`");
                            errorFlag.append("1");
                        }
                    }
                    subjectVO.setSubjectAuxiliaryList(subjectAuxiliaryVOS);
                    subjectVO.setErrMsg(errMsg.toString());
                }

                if (!errorFlag.toString().contains("2")) {
                    subjectVO.setId(IdWorker.getId());
                    String code = subjectVO.getSubjectCode();
                    // 分隔符
                    if (subjectCodeType.intValue() == 1) {
                        if (!code.contains(subjectCodeRule)) {
                            subjectVO.setInnerCode(String.valueOf(subjectVO.getId()));
                        } else {
                            String parentCode = code.substring(0, code.lastIndexOf(subjectCodeRule));
                            SubjectVO parentVO = parentMap.get(parentCode);
                            subjectVO.setParentId(parentVO.getId());
                            subjectVO.setInnerCode(parentVO.getInnerCode() + "|" + subjectVO.getId());
                        }

                    } else {
                        // 4-2-2-2  1401  140101
                        int codeLen = code.length();
                        Integer par = selfRuleMap.get(codeLen);
                        if (par == null) {
                            subjectVO.setInnerCode(String.valueOf(subjectVO.getId()));
                        } else {
                            String parentCode = code.substring(0, par);
                            SubjectVO parentVO = parentMap.get(parentCode);
                            subjectVO.setParentId(parentVO.getId());
                            subjectVO.setInnerCode(parentVO.getInnerCode() + "|" + subjectVO.getId());
                        }
                    }
                    parentMap.put(code, subjectVO);

                    successList.add(subjectVO);
                } else {
                    errorList.add(subjectVO);
                }
            }

            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, SubjectVO.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     *
     * @author songlx
     * @date: 2022/11/22
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<SubjectVO> subjectVOS) {
        return CommonResponse.success(service.saveImport(subjectVOS));
    }

    public static void main(String[] args) {
        String a = "186-09";
        String[] split = a.split("\\-");
        System.out.println(split.length);


    }

}
