package com.ejianc.business.accplat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.bean.SubjectContrastDetailEntity;
import com.ejianc.business.accplat.bean.SubjectContrastDetailInfluenceEntity;
import com.ejianc.business.accplat.bean.SubjectContrastEntity;
import com.ejianc.business.accplat.mapper.SubjectContrastMapper;
import com.ejianc.business.accplat.service.ISubjectContrastDetailInfluenceService;
import com.ejianc.business.accplat.service.ISubjectContrastService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 科目对照
 *
 * @author generator
 *
 */
@Service("subjectContrastService")
public class SubjectContrastServiceImpl extends BaseServiceImpl<SubjectContrastMapper, SubjectContrastEntity> implements ISubjectContrastService {

    @Autowired
    private ISubjectContrastDetailInfluenceService detailInfluenceService;

    @Override
    public boolean insertOrUpdate(SubjectContrastEntity entity) {
        Boolean success = super.saveOrUpdate(entity, false);
        if (success) {
            List<SubjectContrastDetailEntity> subjectContrastDetailList = entity.getSubjectContrastDetailList();
            List<Long> subjectContrastDetailInfluenceIdList = new ArrayList<>();
            if (ListUtil.isNotEmpty(subjectContrastDetailList)) {
                subjectContrastDetailList.forEach(detail -> {
                    LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                    influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, detail.getId());
                    List<SubjectContrastDetailInfluenceEntity> influenceEntities = detailInfluenceService.list(influenceEntityLambdaQueryWrapper);
                    Map<Long, SubjectContrastDetailInfluenceEntity> oldDetailInfluenceEntityMap = new HashMap<>();
                    if (ListUtil.isNotEmpty(influenceEntities)) {
                        oldDetailInfluenceEntityMap = influenceEntities.stream()
                                .collect(Collectors.toMap(SubjectContrastDetailInfluenceEntity::getInfluenceId, t -> t));
                    }
                    List<SubjectContrastDetailInfluenceEntity> subjectContrastDetailInfluenceList = detail.getSubjectContrastDetailInfluenceList();
                    if (ListUtil.isNotEmpty(subjectContrastDetailInfluenceList)) {
                        for (SubjectContrastDetailInfluenceEntity subjectContrastDetailInfluenceEntity : subjectContrastDetailInfluenceList) {
                            subjectContrastDetailInfluenceEntity.setContrastId(entity.getId());
                            subjectContrastDetailInfluenceEntity.setDetailId(detail.getId());
                            Long influenceId = subjectContrastDetailInfluenceEntity.getInfluenceId();
                            SubjectContrastDetailInfluenceEntity old = oldDetailInfluenceEntityMap.get(influenceId);
                            if (old != null) {
                                old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                                old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                                BeanUtils.copyProperties(old, subjectContrastDetailInfluenceEntity, "influenceValue", "influenceValueView");
                            }
                        }
                        detailInfluenceService.saveOrUpdateBatch(subjectContrastDetailInfluenceList);
                        subjectContrastDetailInfluenceIdList.addAll(subjectContrastDetailInfluenceList.stream().map(SubjectContrastDetailInfluenceEntity::getId).collect(Collectors.toList()));
                    }

                });
            }

            LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaDelWrapper = new LambdaQueryWrapper<>();
            influenceEntityLambdaDelWrapper.eq(SubjectContrastDetailInfluenceEntity::getContrastId, entity.getId());
            influenceEntityLambdaDelWrapper.notIn(CollectionUtils.isNotEmpty(subjectContrastDetailInfluenceIdList), SubjectContrastDetailInfluenceEntity::getId, subjectContrastDetailInfluenceIdList);
            detailInfluenceService.remove(influenceEntityLambdaDelWrapper);

        }
        return true;
    }
}
