package com.ejianc.business.accplat.service.impl;

import com.ejianc.business.accplat.bean.SubjectAuxiliaryEntity;
import com.ejianc.business.accplat.bean.SubjectEntity;
import com.ejianc.business.accplat.mapper.SubjectMapper;
import com.ejianc.business.accplat.service.ISubjectAuxiliaryService;
import com.ejianc.business.accplat.service.ISubjectService;
import com.ejianc.business.accplat.vo.SubjectAuxiliaryVO;
import com.ejianc.business.accplat.vo.SubjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 会计科目
 * 
 * @author generator
 * 
 */
@Service("subjectService")
public class SubjectServiceImpl extends BaseServiceImpl<SubjectMapper, SubjectEntity> implements ISubjectService{


    @Autowired
    private ISubjectAuxiliaryService subjectAuxiliaryService;

    @Override
    public String saveImport(List<SubjectVO> subjectVOS) {
        List<SubjectAuxiliaryVO> auxiliaryVOList = new ArrayList<>();
        for (SubjectVO subjectVO : subjectVOS) {
            auxiliaryVOList.addAll(subjectVO.getSubjectAuxiliaryList());
        }
        this.saveOrUpdateBatch(BeanMapper.mapList(subjectVOS, SubjectEntity.class));
        subjectAuxiliaryService.saveOrUpdateBatch(BeanMapper.mapList(auxiliaryVOList, SubjectAuxiliaryEntity.class));
        return "导入成功！";
    }
}
