package com.ejianc.business.custom.transfer.sjyg;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.kingdee.base.vo.save.*;
import com.ejianc.business.voucher.transfer.BaseVoucherTransferService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.utils.GsonUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: 凭证自定义转化-分包过程结算
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Slf4j
@Service("SJYG-SubSettleVoucherCustomTransferService")
public class SJYGSubSettleVoucherCustomTransferService extends BaseVoucherTransferService implements IVoucherTransferService {


    /**
     * @description: 转化原始凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据凭证模板转化原始凭证，可以直接调用transferOriginVoucherByVoucherTemplate
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以根据定义分录转化原始凭证，
     *    如不需要复写getIsGenerateOriginVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferOriginVoucher(VoucherParams voucherParams) {

    }

    /**
     * @description: 转化财务凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据原始凭证转化财务凭证，可以直接调用transferFinanceVoucherByOriginVoucher
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以根据定义分录直接转化财务凭证（或者自定义也转化了原始凭证，可以直接调用transferFinanceVoucherByOriginVoucher），
     *    如不需要复写getIsGenerateFinanceVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferFinanceVoucher(VoucherParams voucherParams) {
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        Map<String, Object> billData = voucherParams.getBillData();
        Object _orgId = billData.get("orgId");
        Object projectName = billData.get("projectName");
        Object settleTaxMny = billData.get("settleTaxMny");

        Long orgId = Long.valueOf(String.valueOf(_orgId));
        BillAccbookSetVO billAccbookSetVO = this.getBillAccbookSet(orgId, voucherParams.getBillTypeCode());
        log.info("billAccbookSetVO:{}", JSONObject.toJSONString(billAccbookSetVO));


        KingDeeVoucherApiSaveVO kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        Model model = new Model();

        // 账簿
        FAccountBookID fAccountBookID = new FAccountBookID();
        fAccountBookID.setFNumber(billAccbookSetVO.getAccbookCode());
        model.setFAccountBookID(fAccountBookID);
        // 日期
        model.setFDate("2023-12-12");
        // FBUSDATE 业务日期
        model.setFBUSDATE("Z");
        // FYEAR 会计年度

        // FPERIOD 期间

        // FVOUCHERGROUPID 凭证字
        FVOUCHERGROUPID fvouchergroupid = new FVOUCHERGROUPID();
        fvouchergroupid.setFNumber("PRE001");
        model.setFVOUCHERGROUPID(fvouchergroupid);
        // FDocumentStatus 审核状态
        model.setFDocumentStatus("Z");




        FEntity fEntity1 = new FEntity();
        // 摘要
        fEntity1.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
        // FAMOUNTFOR 原币金额
        fEntity1.setFAMOUNTFOR(settleTaxMny);
        // FDEBIT 借方金额
        fEntity1.setFDEBIT(settleTaxMny);

        // FCURRENCYID 币别
        FCURRENCYID fcurrencyid = new FCURRENCYID();
        fcurrencyid.setFNumber("PRE001");
        fEntity1.setFCURRENCYID(fcurrencyid);

        // FEXCHANGERATETYPE 汇率类型
        FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
        fexchangeratetype.setFNumber("HLTX01_SYS");
        fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);

        // FEXCHANGERATE 汇率
        //fEntity1.setFEXCHANGERATE("1");


        FEntity fEntity2 = new FEntity();
        // 摘要
        fEntity2.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
        // FAMOUNTFOR 原币金额
        fEntity2.setFAMOUNTFOR(settleTaxMny);
        // FCREDIT 贷方金额
        fEntity2.setFCREDIT(settleTaxMny);

        // FCURRENCYID 币别
        fEntity2.setFCURRENCYID(fcurrencyid);

        // FEXCHANGERATETYPE 汇率类型
        fEntity2.setFEXCHANGERATETYPE(fexchangeratetype);

        voucherParams.setFinanceVoucher(GsonUtil.objToMap(kingDeeVoucherApiSaveVO));
    }


    /**
     * @description: 是否生成原始凭证，如为true，请在transferOriginVoucher中转化
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public Boolean getIsGenerateOriginVoucherFlag(VoucherParams voucherParams) {
        return Boolean.FALSE;
    }
}
