package com.ejianc.business.kingdee.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.kingdee.api.KingDeeGalaxyInvokeHelper;
import com.ejianc.business.kingdee.base.consts.FormIdConsts;
import com.ejianc.business.kingdee.base.consts.KingDeeQueryConsts;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.SuccessEntity;
import com.ejianc.business.kingdee.base.vo.query.KingDeeVoucherApiQueryVO;
import com.ejianc.business.kingdee.base.vo.save.FEntity;
import com.ejianc.business.kingdee.base.vo.save.KingDeeVoucherApiSaveVO;
import com.ejianc.business.kingdee.base.vo.save.Model;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.utils.GsonUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.gson.Gson;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description: 金蝶凭证服务
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service
public class KingDeeGalaxyVoucherService extends KingDeeGalaxyInvokeHelper implements IFinanceVoucherService {

    /**
     * @description: 金蝶云星空接入模式，这家比较特殊，不同接入模式调用方式不同，无语
     *   # 是否生态模式
     *   # true: 云接入模式
     *   # false: 私有化服务接入模式
     */
    @Value("${kdapi.access-type}")
    private boolean accessType;

    /**
     * @description: 保存财务凭证
     *
     * JSONObject data = new JSONObject();
     *                 JSONObject model = new JSONObject();
     *
     *                 JSONObject _FAccountBookID = new JSONObject();
     *                 _FAccountBookID.put("FNumber", "S01");
     *                 model.put("FAccountBookID", _FAccountBookID);
     *                 model.put("FDate", "2023-12-12");
     *                 model.put("FDocumentStatus", "Z");
     *
     *
     *                 JSONObject _FVOUCHERGROUPID = new JSONObject();
     *                 _FVOUCHERGROUPID.put("FNumber", "PRE001");
     *                 model.put("FVOUCHERGROUPID", _FVOUCHERGROUPID);
     *
     *                 JSONArray _FEntity = new JSONArray();
     *
     *
     *                 JSONObject sub1 = new JSONObject();
     *
     *                 sub1.put("FEXPLANATION", "供应商摘要");
     *                 //科目编码
     *                 JSONObject _FACCOUNTID = new JSONObject();
     *                 _FACCOUNTID.put("FNumber", "2202.02");
     *                 sub1.put("FACCOUNTID", _FACCOUNTID);
     *
     *                 //币别
     *                 JSONObject _FCURRENCYID = new JSONObject();
     *                 _FCURRENCYID.put("FNumber", "PRE001");
     *                 sub1.put("FCURRENCYID", _FCURRENCYID);
     *
     *                 //汇率类型
     *                 JSONObject _FEXCHANGERATETYPE = new JSONObject();
     *                 _FEXCHANGERATETYPE.put("FNumber", "HLTX01_SYS");
     *                 sub1.put("FEXCHANGERATETYPE", _FEXCHANGERATETYPE);
     *
     *                 sub1.put("FEXCHANGERATE", "1");
     *
     *                 sub1.put("FAMOUNTFOR", 667);
     *                 sub1.put("FDEBIT", 667);
     *
     *                 //核算对象
     *                 JSONObject _FDetailID = new JSONObject();
     *                 JSONObject _FDETAILID__FFLEX4 = new JSONObject();
     *                 _FDETAILID__FFLEX4.put("FNumber", "1.001");
     *                 _FDetailID.put("FDETAILID__FFLEX4", _FDETAILID__FFLEX4);
     *                 sub1.put("FDetailID", _FDetailID);
     *
     *
     *                 JSONObject sub2 = new JSONObject();
     *                 sub2.put("FEXPLANATION", "2222");
     *                 //科目编码
     *                 JSONObject _FACCOUNTID2 = new JSONObject();
     *                 _FACCOUNTID2.put("FNumber", "1001.01");
     *                 sub2.put("FACCOUNTID", _FACCOUNTID2);
     *
     *                 //币别
     *                 JSONObject _FCURRENCYID2 = new JSONObject();
     *                 _FCURRENCYID2.put("FNumber", "PRE001");
     *                 sub2.put("FCURRENCYID", _FCURRENCYID2);
     *
     *                 //汇率类型
     *                 JSONObject _FEXCHANGERATETYPE2 = new JSONObject();
     *                 _FEXCHANGERATETYPE2.put("FNumber", "HLTX01_SYS");
     *                 sub2.put("FEXCHANGERATETYPE", _FEXCHANGERATETYPE2);
     *
     *                 sub2.put("FEXCHANGERATE", "1");
     *
     *                 sub2.put("FAMOUNTFOR", 667);
     *                 sub2.put("FCREDIT", 667);
     *
     *                 //核算对象
     *                 JSONObject _FDetailID2 = new JSONObject();
     *
     *             JSONObject _FDETAILID__FFLEX4_2 = new JSONObject();
     *             _FDETAILID__FFLEX4_2.put("FNumber", "1.001");
     *             _FDetailID2.put("FDETAILID__FFLEX4", _FDETAILID__FFLEX4_2);
     *             JSONObject _FDETAILID__FFLEX5_2 = new JSONObject();
     *             _FDETAILID__FFLEX5_2.put("FNumber", "03.02.0003");
     *             _FDetailID2.put("FDETAILID__FFLEX5", _FDETAILID__FFLEX5_2);
     *             sub2.put("FDetailID", _FDetailID2);
     *
     *                 _FEntity.add(sub1);
     *                 _FEntity.add(sub2);
     *                 model.put("FEntity", _FEntity);
     *                 data.put("Model", model);
     *                 System.out.println("data:" + JSON.toJSONString(data, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
     *                 this.Save(getFormId(), JSON.toJSONString(data));
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                Map<String, Object> map = voucherParams.getFinanceVoucher();
                Object model = map.get("Model");
                RepoResult repoResult = null;
                if(model instanceof List){
                    repoResult = this.batchSave(FormIdConsts.GL_VOUCHER, GsonUtil.objToString(map));
                } else {
                    repoResult = this.save(FormIdConsts.GL_VOUCHER, GsonUtil.objToString(map));
                }
                if (repoResult.isSuccess()) {
                    ArrayList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                    ArrayList<VoucherSimpleVO> voucherSimpleVOS = new ArrayList<>();
                    for (SuccessEntity successEntity : successEntitys) {
                        VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                        voucherSimpleVO.setVoucherId(successEntity.getId());
                        voucherSimpleVO.setBillCode(successEntity.getNumber());
                        voucherSimpleVOS.add(voucherSimpleVO);
                    }
                    return CommonResponse.success(VoucherInfo.getVoucherInfo(voucherSimpleVOS));
                } else {
                    resp = repoResult.toCommonResponse();
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 批量保存财务凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                Map<String, Object> map = voucherParams.getFinanceVoucher();
                RepoResult repoResult = this.batchSave(FormIdConsts.GL_VOUCHER, GsonUtil.objToString(map));
                if (repoResult.isSuccess()) {
                    ArrayList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                    ArrayList<VoucherSimpleVO> voucherSimpleVOS = new ArrayList<>();
                    for (SuccessEntity successEntity : successEntitys) {
                        VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                        voucherSimpleVO.setVoucherId(successEntity.getId());
                        voucherSimpleVO.setBillCode(successEntity.getNumber());
                        voucherSimpleVOS.add(voucherSimpleVO);
                    }
                    return CommonResponse.success(VoucherInfo.getVoucherInfo(voucherSimpleVOS));
                } else {
                    resp = repoResult.toCommonResponse();
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 查询财务凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherInfo
     */
    @Override
    public CommonResponse get(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
                if (CollectionUtils.isEmpty(vouchers)) {
                    throw new BusinessException("vouchers不能为空");
                }
                if(vouchers.size() == 1){
                    VoucherSimpleVO voucherSimpleVO = vouchers.get(0);
                    JSONObject paramObj = new JSONObject();
                    paramObj.put("Id", voucherSimpleVO.getVoucherId());
                    RepoResult repoResult = this.view(FormIdConsts.GL_VOUCHER, paramObj.toJSONString());

                    if (repoResult.isSuccess()) {
                        JSONObject result = (JSONObject) repoResult.getResult();
                        return CommonResponse.success(result);
                    } else {
                        resp = repoResult.toCommonResponse();
                    }
                } else {
                    KingDeeVoucherApiQueryVO kingDeeVoucherApiQueryVO = new KingDeeVoucherApiQueryVO();
                    List<String> ids = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.toList());
                    kingDeeVoucherApiQueryVO.setFilterStringForEqIds(ids);
                    List<Map<String, Object>> maps = this.executeBillQuery(GsonUtil.objToString(kingDeeVoucherApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
                    resp = CommonResponse.success(maps);
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 查询财务凭证List
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse getList(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                KingDeeVoucherApiQueryVO kingDeeVoucherApiQueryVO = new KingDeeVoucherApiQueryVO();
                List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
                List<String> ids = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.toList());
                kingDeeVoucherApiQueryVO.setFilterStringForEqIds(ids);
                List<Map<String, Object>> maps = this.executeBillQuery(GsonUtil.objToString(kingDeeVoucherApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
                resp = CommonResponse.success(maps);
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 删除财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
                if (CollectionUtils.isEmpty(vouchers)) {
                    throw new BusinessException("vouchers不能为空");
                }
                String voucherIds = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.joining(","));
                JSONObject paramObj = new JSONObject();
                paramObj.put("Ids", voucherIds);
                RepoResult repoResult = this.delete(FormIdConsts.GL_VOUCHER, paramObj.toJSONString());
                if (repoResult.isSuccess()) {
                    String result = String.valueOf(repoResult.getResult());
                    return CommonResponse.success(JSON.parseObject(result));
                } else {
                    resp = repoResult.toCommonResponse();
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 依据原始凭证转化财务凭证参数
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public VoucherParams convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        return voucherParams;
    }



    public static void main(String[] args) {
        Map map = new HashMap<>();
        map.put("Name", "tom");
        map.put("Age", 20);

        String s = new Gson().toJson(map);
        System.out.println(s);

        KingDeeVoucherApiSaveVO kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO();
        Model model = new Model();
        FEntity fEntity = new FEntity();
        fEntity.setFAMOUNTFOR(ComputeUtil.toBigDecimal(11));
        model.setFEntity(Arrays.asList(fEntity));
        kingDeeVoucherApiSaveVO.setModel(model);
        //Map map = BeanMapper.map(kingDeeVoucherApiSaveVO, Map.class);
        //JSONObject jsonObject = new JSONObject(map);
        String s1 = new Gson().toJson(kingDeeVoucherApiSaveVO);
        System.out.println(s1);


        Map<String, Object> map1 = JSON.parseObject(new Gson().toJson(kingDeeVoucherApiSaveVO), Map.class);
        System.out.println(map1);


        System.out.println(JSONObject.toJSONString(kingDeeVoucherApiSaveVO));

    }
}
