package com.ejianc.business.voucher.service;

import com.ejianc.business.accplat.vo.VoucherTemplateVO;
import com.ejianc.framework.cache.redis.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description: 获取凭证模板
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service
public class VoucherTemplateCacheProvider {

    private final String VOUCHER_TEMPLATE_CACHE_PREFIX = "ejcvouchertemplate:";

    @Autowired
    private CacheManager cacheManager;


    public VoucherTemplateVO loadTemplateFromCache(Long tenantId, String billTypeCode) {
        String cacheKey = getCacheKey(tenantId, billTypeCode);
        VoucherTemplateVO voucherTemplateVO = cacheManager.get(cacheKey);
        if(null == voucherTemplateVO) {
            //TODO 缓存没有凭证模板则查询，放入缓存
            voucherTemplateVO = null;
            saveTemplateToCache(cacheKey, voucherTemplateVO);
        }
        return voucherTemplateVO;
    }

    public void saveTemplateToCache(String cacheKey, VoucherTemplateVO voucherTemplateVO) {
        cacheManager.set(cacheKey, voucherTemplateVO);
    }


    public void removeTemplateCache(Long tenantId, String billTypeCode) {
        String cacheKey = getCacheKey(tenantId, billTypeCode);
        if(cacheManager.exists(cacheKey)){
            cacheManager.removeCache(cacheKey);
        }
    }

    private String getCacheKey(Long tenantId, String billTypeCode) {
        return VOUCHER_TEMPLATE_CACHE_PREFIX + billTypeCode + tenantId;
    }
}
