package com.ejianc.business.yonyou.base.datacenter.impl;

import com.ejianc.business.yonyou.base.context.InvocationInfoProxy;
import com.ejianc.business.yonyou.base.exception.BusinessException;
import com.ejianc.business.yonyou.base.datacenter.pojo.GatewayAddressResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

import java.util.Objects;


/**
 * @author nishch
 * @description: TODO
 * @date 2022/3/8
 */
@Slf4j
public class QueryDataCenterUrlProviderImpl extends DataCenterUrlProviderImpl {

    /**
     * TODO：不建议每次都调用接口，租户一旦创建所属数据中心不会再改变，建议将租户地址对应关系持久化到数据库和缓存中
     * @return GatewayAddressResponse.GatewayAddressDTO
     */
    @Override
    public GatewayAddressResponse.GatewayAddressDTO queryGatewayAddress() {
        ResponseEntity<GatewayAddressResponse> responseEntity = restTemplate.getForEntity(properties.getGatewayAddressUrl().replace("%s", queryTenantId()), GatewayAddressResponse.class);
        return Objects.requireNonNull(responseEntity.getBody()).getData();
    }

    /**
     * 请在切面中设置上下文
     * @return String
     */
    @Override
    public String queryTenantId() {
        String tenantId = null;
        if (ucfCoreProperties.getAccessType()) {
            tenantId = InvocationInfoProxy.getTenantId();
            if (StringUtils.isEmpty(tenantId)) {
                throw new BusinessException("生态模式获取租户id为空，请在上下文中设置租户信息");
            }
        } else {
            tenantId = super.queryTenantId();
        }
        return tenantId;
    }
}
