package com.ejianc.business.yonyou.base.module.auth.isv.impl;

import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import com.ejianc.business.yonyou.base.module.auth.isv.ISVCryptoService;
import com.ejianc.business.yonyou.base.network.cryptor.EncryptionHolder;
import com.ejianc.business.yonyou.base.network.cryptor.ISVRequestCrypto;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 本类主要用于
 *
 * @author liuhaoi
 * @since Created At 2020/5/25 1:33 下午
 */
@Slf4j
@RequiredArgsConstructor
public class ISVCryptoServiceImpl implements ISVCryptoService {

    private final OpenApiProperties properties;

    @Override
    public String decrypt(EncryptionHolder holder) {
        ISVRequestCrypto crypto = buildCrypto();
        return crypto.decrypt(holder);
    }

    @Override
    public EncryptionHolder encrypt(String source) {
        ISVRequestCrypto crypto = buildCrypto();
        return crypto.encrypt(source);
    }

    private ISVRequestCrypto buildCrypto() {
        return new ISVRequestCrypto(properties.getAppKey(), properties.getAppSecret());
    }
}
