package com.ejianc.business.yonyou.base.module.common;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 本类主要用于
 *
 * @author liuhaoi
 * @since Created At 2020/5/11 10:35 上午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OpenApiAccessToken implements Serializable {

    private String accessToken;

    private Long expiredAt;

    @Data
    public static class OpenApiAccessTokenDTO {

        private String access_token;
        private Long expire;

        public OpenApiAccessToken build() {
            return new OpenApiAccessToken(access_token, System.currentTimeMillis() + expire * 1000);
        }

    }

    public boolean expired() {
        return expiredAt != null && System.currentTimeMillis() + 1000 < expiredAt;
    }

}
