package com.ejianc.business.yonyou.base.module.token;

import com.ejianc.business.accplat.vo.VoucherTemplateVO;
import com.ejianc.business.yonyou.base.module.common.OpenApiAccessToken;
import com.ejianc.framework.cache.redis.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;

/**
 * @author nishch
 * @description:
 * @date 2022/8/12
 */
@Component
public class OpenApiTokenCacheProviderImpl implements OpenApiTokenCacheProvider{

    private final String CACHE_PREFIX = "yonyouystoken:";

    @Autowired
    private CacheManager cacheManager;

    @Override
    public OpenApiAccessToken loadTokenFromCache(String tenantId) {
        String cacheKey = getCacheKey(tenantId);
        OpenApiAccessToken token = cacheManager.get(cacheKey);
        if(token != null && token.expired()){
            token = null;
        }
        return token;
    }

    @Override
    public void saveTokenToCache(String tenantId, OpenApiAccessToken token) {
        cacheManager.set(getCacheKey(tenantId), token);
    }

    private String getCacheKey(String tenantId) {
        return CACHE_PREFIX + tenantId;
    }

}
