package com.ejianc.business.yonyou.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.business.yonyou.api.BaseOpenApi;
import com.ejianc.business.yonyou.api.OpenApiURL;
import com.ejianc.business.yonyou.base.context.InvocationInfoProxy;
import com.ejianc.business.yonyou.base.module.reponse.ApiDataResponse;
import com.ejianc.business.yonyou.base.properties.UCFCoreProperties;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @description: 用友凭证
 **/
@Service
public class YonYouYsVoucherService extends BaseOpenApi implements IFinanceVoucherService {

    @Resource
    UCFCoreProperties ucfCoreProperties;


    /**
     * 发起请求前的校验
     */
    public boolean check() {
        if (ucfCoreProperties.getAccessType()) {
            //TODO：如果是生态模式需要设置租户信息
            String tenantId = null;
            if (tenantId == null) throw new BusinessException("ISV模式");
            InvocationInfoProxy.setTenantId(tenantId);
        }
        return true;
    }

    /**
     * @description: {
     * 	"srcSystemCode": "figl",
     * 	"accbookCode": "dxbook003",
     * 	"voucherTypeCode": "01",
     * 	"billCode": 111,
     * 	"attachedBill": 1,
     * 	"makerMobile": "18510047432",
     * 	"makerEmail": "liuyazh@yonyou.com",
     * 	"makeTime": "2021-08-25",
     * 	"description": "凭证头摘要",
     * 	"defInfo1": "自定义扩展信息1",
     * 	"defInfo2": "自定义扩展信息2",
     * 	"defInfo3": "自定义扩展信息3",
     * 	"defInfo4": "自定义扩展信息4",
     * 	"defInfo5": "自定义扩展信息5",
     * 	"bodies": [
     *                {
     * 			"description": "购买xx设备",
     * 			"accsubjectCode": "1001",
     * 			"price": 15,
     * 			"quantity": 2,
     * 			"currencyCode": "CNY",
     * 			"busidate": "2021-08-23",
     * 			"rateType": "01",
     * 			"organizeRateTypeCode": "CWGGZDH_ZZBHLLX1",
     * 			"groupRatetypeCode": "CWGGZDH_JTBHLLX1",
     * 			"globalRatetypeCode": "CWGGZDH_QJUHLLX1",
     * 			"rateOrg": 1,
     * 			"organizeRate": 1,
     * 			"rateGroup": 1,
     * 			"rateGlobal": 1,
     * 			"debitOriginal": 13.1,
     * 			"creditOriginal": 13.1,
     * 			"debitOrg": 13.1,
     * 			"organizeDebitAmount": 13.1,
     * 			"debitGroup": 13.1,
     * 			"debitGlobal": 13.1,
     * 			"creditOrg": 13.1,
     * 			"organizeCreditAmount": 13.1,
     * 			"creditGroup": 13.1,
     * 			"creditGlobal": 13.1,
     * 			"secondOrgCode": "fwefqfe",
     * 			"settlementModeCode": "02",
     * 			"billTime": "2021-08-23",
     * 			"billNo": "1235",
     * 			"bankVerifyCode": "789703",
     * 			"clientAuxiliaryList": [
     *                {
     * 					"filedCode": "000433",
     * 					"valueCode": "0000000001"
     *                }
     * 			],
     * 			"cashflowList": [
     *                {
     * 					"innerOrgCode": "AAA",
     * 					"mainItemCode": "1111",
     * 					"supItemCode": "031501",
     * 					"amountOriginal": 12,
     * 					"amountOrg": 12
     *                }
     * 			]
     *        }
     * 	]
     * }
     *
     */

    /**
     * @description: 保存凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        check();
        Map<String, Object> params = voucherParams.getFinanceVoucher();
        //BigDecimal taxMny = ComputeUtil.scaleTwo(voucherVO.getTaxMny());
        //Map<String, Object> params = new HashMap<>();
        Object supplierCode = Optional.ofNullable(params.get("supplierCode")).orElse("00LW000001");
        Object projectCode = Optional.ofNullable(params.get("projectCode")).orElse("XM001");
        Object projectName = Optional.ofNullable(params.get("projectName")).orElse("益企联科技大厦");
        String description = projectName + "_分包过程结算";
        Object taxMny = params.get("taxMny");
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCode", "JZ");
        params.put("makerMobile", "13520563725");

        JSONObject body1 = new JSONObject();
        body1.put("description", description);
        body1.put("accsubjectCode", "590101");
        body1.put("debitOriginal", taxMny);
        body1.put("debitOrg", taxMny);
        body1.put("debitGroup", taxMny);
        body1.put("debitGlobal", taxMny);
        body1.put("organizeDebitAmount", taxMny);
        JSONArray clientAuxiliaryList1 = new JSONArray();
        JSONObject clientAuxiliaryList1_1 = new JSONObject();
        clientAuxiliaryList1_1.put("filedCode", "0002");
        clientAuxiliaryList1_1.put("valueCode", projectCode);
        clientAuxiliaryList1.add(clientAuxiliaryList1_1);
        body1.put("clientAuxiliaryList", clientAuxiliaryList1);
     /*   JSONArray cashflowList1 = new JSONArray();
        JSONObject cashflowList1_1 = new JSONObject();
        cashflowList1_1.put("mainItemCode", "defInfo1");
        cashflowList1_1.put("amountOriginal",  taxMny);
        cashflowList1_1.put("amountOrg",  taxMny);
        cashflowList1.add(cashflowList1_1);
        body1.put("cashflowList", cashflowList1);*/

        JSONObject body2 = new JSONObject();
        body2.put("description", description);
        body2.put("accsubjectCode", "220201");
        body2.put("creditOriginal", taxMny);
        body2.put("creditOrg", taxMny);
        body2.put("creditGroup", taxMny);
        body2.put("creditGlobal", taxMny);
        body2.put("organizeCreditAmount", taxMny);

        JSONArray clientAuxiliaryList2 = new JSONArray();
        JSONObject clientAuxiliaryList2_1 = new JSONObject();
        clientAuxiliaryList2_1.put("filedCode", "0002");
        clientAuxiliaryList2_1.put("valueCode", projectCode);
        clientAuxiliaryList2.add(clientAuxiliaryList2_1);
        JSONObject clientAuxiliaryList2_2 = new JSONObject();
        clientAuxiliaryList2_2.put("filedCode", "0004");
        clientAuxiliaryList2_2.put("valueCode", supplierCode);
        clientAuxiliaryList2.add(clientAuxiliaryList2_2);
        body2.put("clientAuxiliaryList", clientAuxiliaryList2);
        /*JSONArray cashflowList2 = new JSONArray();
        JSONObject cashflowList2_1 = new JSONObject();
        cashflowList2_1.put("mainItemCode", "defInfo1");
        cashflowList2_1.put("amountOriginal",  "100.00");
        cashflowList2_1.put("amountOrg",  "100.00");
        cashflowList2.add(cashflowList2_1);

        JSONObject cashflowList2_2 = new JSONObject();
        cashflowList2_2.put("mainItemCode", "defInfo2");
        cashflowList2_2.put("amountOriginal",  "100.00");
        cashflowList2_2.put("amountOrg",  "100.00");
        cashflowList2.add(cashflowList2_2);
        body2.put("cashflowList", cashflowList2);*/
        JSONArray bodies = new JSONArray();
        bodies.add(body1);
        bodies.add(body2);
        params.put("bodies", bodies);

        ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.ADD_VOUCHER, params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();

        if (commonResponse.isSuccess()) {
            Map<String, Object> data = (Map<String, Object>) commonResponse.getData();
            VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
            voucherSimpleVO.setVoucherId(data.get("voucherId").toString());
            voucherSimpleVO.setPeriod(data.get("period").toString());
            voucherSimpleVO.setBillCode(data.get("billCode").toString());
            commonResponse.setData(VoucherInfo.getVoucherInfo(voucherSimpleVO));
        }
        return commonResponse;
    }

    /**
     * @description: 保存多个财务凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        return null;
    }


    /**
     * @description: 查询凭证
     * pager	object	否	否	分页对象信息
     * pageIndex	int	否	否	当前页    示例：1
     * pageSize	int	否	否	每页数量（最大1000）    示例：20
     * ccbookCode	string	否	是	账簿code    示例：dxbook001
     * periodStart	string	否	否	起始期间（默认当前系统年月 ）格式为yyyy-MM    示例：2021-08
     * periodEnd	string	否	否	截止期间（默认当前系统年月）格式为yyyy-MM    示例：2021-08
     * billcodeMin	int	否	否	凭证号区间左端点    示例：10
     * billcodeMax	int	否	否	凭证号区间右端点    示例：10
     * @author songlx
     * @date: 2023/11/21
     */
    @Override
    public CommonResponse get(VoucherInfo voucherInfo) {
        VoucherSimpleVO voucherSimpleVO = voucherInfo.getVouchers().get(0);
        Map<String, Object> params = new HashMap<>();
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCodeList", Arrays.asList("JZ"));
        params.put("periodStart", voucherSimpleVO.getPeriod());
        params.put("periodEnd", voucherSimpleVO.getPeriod());
        params.put("billcodeMin", voucherSimpleVO.getBillCode());
        params.put("billcodeMax", voucherSimpleVO.getBillCode());
        JSONObject pager = new JSONObject();
        pager.put("pageIndex", 1);
        pager.put("pageSize", 500);
        params.put("pager", pager);

        ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.QUERY_VOUCHERS, params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();

        if (commonResponse.isSuccess()) {
            Map<String, Object> data = (Map<String, Object>) commonResponse.getData();
            List<Map<String, Object>> recordList = (List<Map<String, Object>>) data.get("recordList");
            if (CollectionUtils.isNotEmpty(recordList)) {
                commonResponse.setData(recordList.get(0));
            }
        }
        return commonResponse;
    }

    /**
     * @description: 查询财务凭证List
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse getList(VoucherInfo voucherInfo) {
        return null;
    }


    /**
     * @description: 凭证删除, 目前ys只支持单个删除
     * ids: ["E5919010-0035-4996-A492-EB53F73CE6BA"]
     * @author songlx
     * @date: 2023/11/22
     */
    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
        if(CollectionUtils.isNotEmpty(vouchers)){
            Map<String, Object> params = new HashMap<>();
            params.put("ids", Arrays.asList(vouchers.get(0).getVoucherId()));
            ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.DEL_VOUCHER, params, ApiDataResponse.class);
            apiDataResponse.toCommonResponse();
        }
        return CommonResponse.success();
    }

    /**
     * @description: 依据原始凭证转化财务凭证参数
     * @return {@link Map< String, Object>}
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public VoucherParams convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {




        return voucherParams;
    }


}
