package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.bean.AccbookEntity;
import com.ejianc.business.accplat.service.IAccbookService;
import com.ejianc.business.accplat.vo.AccbookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 账簿
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("accbook")
@Api(value = "账簿", tags = {"账簿"})
public class AccbookController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAccbookService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AccbookVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody AccbookVO saveOrUpdateVO) {
        LambdaQueryWrapper<AccbookEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AccbookEntity::getCode, saveOrUpdateVO.getCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, AccbookEntity::getId, saveOrUpdateVO.getId());
        int count = service.count(wrapper);
        if(count > 0){
            throw new BusinessException("编码已存在！");
        }
        if(saveOrUpdateVO.getId() == null){
            saveOrUpdateVO.setEnabled(1);
        }

        AccbookEntity entity = BeanMapper.map(saveOrUpdateVO, AccbookEntity.class);
        service.saveOrUpdate(entity, false);
        AccbookVO vo = BeanMapper.map(entity, AccbookVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AccbookVO> queryDetail(@RequestParam Long id) {
        AccbookEntity entity = service.selectById(id);
        AccbookVO vo = BeanMapper.map(entity, AccbookVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccbookVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AccbookVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AccbookVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<AccbookEntity> page = service.queryPage(param, false);
        IPage<AccbookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AccbookVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AccbookEntity> list = service.queryList(param);
        List<AccbookVO> accbookVOS = BeanMapper.mapList(list, AccbookVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", accbookVOS);
        ExcelExport.getInstance().export("Accbook-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAccbookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> refAccbookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AccbookEntity> page = service.queryPage(param, false);
        IPage<AccbookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AccbookVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("启用/停用")
    @RequestMapping(value = "/enabled", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody AccbookVO accbookVO) {
        LambdaUpdateWrapper<AccbookEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AccbookEntity::getId, accbookVO.getId());
        wrapper.set(AccbookEntity::getEnabled, accbookVO.getEnabled());
        service.update(wrapper);
        return CommonResponse.success("启用/停用成功！");
    }

}
