package com.ejianc.business.kingdee.base.vo.query;

import com.ejianc.business.kingdee.base.consts.FormIdConsts;
import com.ejianc.business.kingdee.base.consts.KingDeeQueryConsts;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;


/**
 * KingDeeVoucherApiQueryVO
 *
 * FormId
 * String
 * 必录
 * ER_ExpenseRequest
 * 业务对象表单Id（必录）
 * FieldKeys
 * String
 * 必录
 * 需查询的字段key集合，字符串类型，格式："key1,key2,..."（必录） 注（查询单据体内码,需加单据体Key和下划线,如：FEntryKey_FEntryId）
 * FilterString
 * Array
 * 非必录
 * []
 * 过滤条件，数组类型，如：[{"Left":"(","FieldName":"Field1","Compare":"67","Value":"111","Right":")","Logic":"0"},{"Left":"(","FieldName":"Field2","Compare":"67","Value":"222","Right":")","Logic":"0"}]
 * OrderString
 * String
 * 非必录
 * 排序字段，字符串类型（非必录）
 * TopRowCount
 * Integer
 * 非必录
 * 0
 * 返回总行数，整型（非必录）
 * StartRow
 * Integer
 * 非必录
 * 0
 * 开始行索引，整型（非必录）
 * Limit
 * Integer
 * 非必录
 * 2000
 * 最大行数，整型，不能超过10000（非必录）
 * SubSystemId
 * String
 * 非必录
 * 表单所在的子系统内码，字符串类型（非必录）
 */
@Data
public class KingDeeVoucherApiQueryVO extends VoucherApiQueryVO {

    private String FormId = FormIdConsts.GL_VOUCHER;
    private String FieldKeys = KingDeeQueryConsts.FIELDKEYS;
    private String FilterString;
    private String OrderString;
    int StartRow = 0;
    int Limit = 0;
    int TopRowCount = 0;


    public static String eqId(String id) {
        return KingDeeQueryConsts.FVOUCHERID + "=" + id;
    }


    public void setFilterStringForEqIds(List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ids.size(); i++) {
                sb.append(eqId(ids.get(i)));
                if (i != ids.size() - 1) {
                    sb.append(" or ");
                }
            }
            this.setFilterString(sb.toString());
        }
    }


}