package com.ejianc.business.voucher.service;

import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;


/**
 * @description: 第三方财务凭证接口
 *
 * @author songlx
 * @date: 2023/11/29
 */
public interface IFinanceVoucherService {

    /**
     * @description: 保存财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<VoucherInfo> save(VoucherParams voucherParams);


    /**
     * @description: 保存多个财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams);


    /**
     * @description: 查询财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse get(VoucherInfo voucherInfo);


    /**
     * @description: 查询财务凭证List
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse getList(VoucherInfo voucherInfo);

    /**
     * @description: 删除财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse del(VoucherInfo voucherInfo);


    /**
     * @description: 依据原始凭证转化财务凭证参数
     * @author songlx
     * @date: 2023/11/29
     */
    VoucherParams convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams);


}
