package com.ejianc.business.voucher.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.service.IBillVoucherSetService;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.voucher.consts.VoucherBusinessConsts;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.OriginVoucher;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * @description: VoucherParamsProvider
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Component
public class VoucherParamsBuilder {

    private static final Logger logger = LoggerFactory.getLogger(VoucherParamsBuilder.class);

    @Autowired
    private VoucherServiceFactory voucherServiceFactory;

    @Autowired
    private IBillVoucherSetService billVoucherSetService;


    /**
     * @description: 构建凭证参数，依据billData 得到 voucherData
     * 1、根据tenantid 查询该租户用的什么财务系统
     * 2、TODO 是否需要获取额外的参数：例如项目编码(或者项目id转成编码，金蝶也是用编码对照？？？)，供应商编码
     * 3、根据单据类型编码查询【单据转换设置】在当前租户是根据单据凭证模板转化还是自定义转化规则，转化后生成原始凭证 or 财务凭证
     *  ① 根据凭证模板，查询凭证模板转化规则，转化数据
     *  ② 无凭证模板，走自定义转化
     * 4、校验转化后的参数正确性
     * @author songlx
     * @date: 2023/11/28
     */
    public VoucherParams buildVoucherParams(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        // 1、根据tenantid 查询该租户用的什么财务系统
        Long tenantid = InvocationInfoProxy.getTenantid();
        String systemCode = VoucherBusinessConsts.KINGDEE_GALAXY;
        voucherParams.setSystemCode(systemCode);


        // 3、根据单据类型编码查询【单据转换设置】在当前租户是根据单据凭证模板转化还是自定义转化规则，转化后生成原始凭证 or 财务凭证
        // ① 根据凭证模板，查询凭证模板转化规则，转化数据
        // ② 无凭证模板，走自定义转化
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        String serviceName = Optional.ofNullable(billVoucherSetVO.getCustomTransferServiceName()).orElse(VoucherBusinessConsts.COMMON_VOUCHER_TRANSFER_SERVICE);
        IVoucherTransferService voucherTransferService = voucherServiceFactory.getVoucherTransferService(serviceName);
        voucherTransferService.transfer(voucherParams);

        // 4、校验转化后的参数正确性
        checkVoucherParams(voucherParams);
        return voucherParams;
    }




    private void checkVoucherParams(VoucherParams voucherParams) {
        Boolean isGenerateOriginVoucherFlag = voucherParams.getIsGenerateOriginVoucherFlag();
        Boolean isGenerateFinanceVoucherFlag = voucherParams.getIsGenerateFinanceVoucherFlag();
        OriginVoucher originVoucher = voucherParams.getOriginVoucher();
        Map<String, Object> financeVoucher = voucherParams.getFinanceVoucher();
        if(isGenerateOriginVoucherFlag && originVoucher == null){
            throw new BusinessException("凭证构建参数校验错误：生成原始凭证标识为是，但缺乏原始凭证数据[originVoucher]");
        }
        if(isGenerateFinanceVoucherFlag && financeVoucher == null){
            throw new BusinessException("凭证构建参数校验错误：生成财务凭证标识为是，缺乏财务凭证参数[financeVoucher]");
        }
    }


    public void getExtraParams(String value, String referCode) {
      /*  try {
            JSONArray jsonArray = ReferObjectUtil.getReferEntityValue("789848932208357400", "market-project");
            System.out.println(jsonArray.toJSONString());
        } catch (Exception e) {
            e.printStackTrace();
        }*/
        JSONArray jsonArray = null;
        try {
            jsonArray = ReferObjectUtil.getReferEntityValue(value, referCode);
        } catch (Exception var16) {
            try {
                 jsonArray = ReferObjectUtil.getReferEntityValue(value, referCode);
            } catch (Exception var15) {
                 logger.error("referCode:" + referCode + " id：" + value + "转换出错，--" + var16.getMessage(), var16);
            }
        }
        jsonArray.get(0);
    }

    public String getReferValue(String value, String referCode) {
        try {
            JSONArray jArray = ReferObjectUtil.getReferEntityValue(value, referCode);
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                String name = json.get("name") != null ? json.get("name").toString() : "";
                return name;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return value;
    }

}
