/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.service.IBillVoucherSetService;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billVoucherSet"})
@Api(value="\u4f1a\u8ba1\u5e73\u53f0\u8bbe\u7f6e-\u4f20\u51ed\u8bc1\u8bbe\u7f6e", tags={"\u4f1a\u8ba1\u5e73\u53f0\u8bbe\u7f6e-\u4f20\u51ed\u8bc1\u8bbe\u7f6e"})
public class BillVoucherSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillVoucherSetService service;
    @Autowired
    private IBillTypeApi billTypeApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillVoucherSetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BillVoucherSetVO saveOrUpdateVO) {
        BillVoucherSetEntity entity = (BillVoucherSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BillVoucherSetEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        BillVoucherSetVO vo = (BillVoucherSetVO)BeanMapper.map((Object)((Object)entity), BillVoucherSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillVoucherSetVO> queryDetail(@RequestParam Long id) {
        BillVoucherSetEntity entity = (BillVoucherSetEntity)((Object)this.service.selectById(id));
        BillVoucherSetVO vo = (BillVoucherSetVO)BeanMapper.map((Object)((Object)entity), BillVoucherSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillVoucherSetVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillVoucherSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (params.get("billTypeId") != null) {
            BillTypeVO billTypeVO;
            Object billTypeIdObj = ((Parameter)params.get("billTypeId")).getValue();
            Long billTypeId = Long.valueOf(billTypeIdObj.toString());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BillVoucherSetEntity::getBillTypeId, (Object)billTypeId);
            wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            int count = this.service.count((Wrapper)wrapper);
            if (count == 0 && (billTypeVO = this.getBillType(billTypeId)) != null) {
                BillVoucherSetEntity billVoucherSetEntity = new BillVoucherSetEntity();
                billVoucherSetEntity.setBillTypeId(billTypeVO.getId());
                billVoucherSetEntity.setBillTypeCode(billTypeVO.getBillCode());
                billVoucherSetEntity.setBillTypeName(billTypeVO.getBillName());
                billVoucherSetEntity.setTenantId(InvocationInfoProxy.getTenantid());
                billVoucherSetEntity.setEnabled(0);
                this.service.saveOrUpdate((Object)billVoucherSetEntity);
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillVoucherSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private BillTypeVO getBillType(Long billTypeId) {
        CommonResponse byId = this.billTypeApi.getById(billTypeId);
        return byId.isSuccess() ? (BillTypeVO)byId.getData() : null;
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BIllVoucherSet-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBIllVoucherSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BillVoucherSetVO>> refBIllVoucherSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillVoucherSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u542f\u7528/\u505c\u7528")
    @RequestMapping(value={"/enabled"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody BillVoucherSetVO billVoucherSetVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)billVoucherSetVO.getId());
        wrapper.set(BillVoucherSetEntity::getEnabled, (Object)billVoucherSetVO.getEnabled());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u542f\u7528/\u505c\u7528\u6210\u529f\uff01");
    }
}

