/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.kingdee.test;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeHelper {
    private static final Logger log = LoggerFactory.getLogger(InvokeHelper.class);
    public static String POST_K3CloudURL = "http://123.234.41.174:8090/K3Cloud/";
    private static String CookieVal = null;
    private static Map map = new HashMap();

    private static HttpURLConnection initUrlConn(String url, JSONArray paras) throws Exception {
        URL postUrl = new URL(POST_K3CloudURL.concat(url));
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        if (CookieVal != null) {
            connection.setRequestProperty("Cookie", CookieVal);
        }
        if (!connection.getDoOutput()) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "application/json");
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        UUID uuid = UUID.randomUUID();
        int hashCode = uuid.toString().hashCode();
        JSONObject jObj = new JSONObject();
        jObj.put("format", (Object)1);
        jObj.put("useragent", (Object)"ApiClient");
        jObj.put("rid", (Object)hashCode);
        jObj.put("parameters", (Object)InvokeHelper.chinaToUnicode(paras.toString()));
        jObj.put("timestamp", (Object)new Date().toString());
        jObj.put("v", (Object)"1.0");
        out.writeBytes(jObj.toString());
        out.flush();
        out.close();
        return connection;
    }

    public static boolean Login(String dbId, String user, String pwd, int lang) throws Exception {
        String line;
        boolean bResult = false;
        String sUrl = "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";
        JSONArray jParas = new JSONArray();
        jParas.add((Object)dbId);
        jParas.add((Object)user);
        jParas.add((Object)pwd);
        jParas.add((Object)lang);
        System.out.println(JSONObject.toJSONString((Object)jParas));
        HttpURLConnection connection = InvokeHelper.initUrlConn(sUrl, jParas);
        String key = null;
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            String tempCookieVal;
            if (key.equalsIgnoreCase("Set-Cookie") && (tempCookieVal = connection.getHeaderField(i)).startsWith("kdservice-sessionid")) {
                CookieVal = tempCookieVal;
                break;
            }
            ++i;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        System.out.println(" ============================= ");
        System.out.println(" Contents of post request ");
        System.out.println(" ============================= ");
        while ((line = reader.readLine()) != null) {
            String sResult = new String(line.getBytes(), "utf-8");
            System.out.println(sResult);
            bResult = line.contains("\"LoginResultType\":1");
        }
        System.out.println(" ============================= ");
        System.out.println(" Contents of post request ends ");
        System.out.println(" ============================= ");
        reader.close();
        connection.disconnect();
        return bResult;
    }

    public static void Save(String formId, String content) throws Exception {
        InvokeHelper.Invoke("Save", formId, content);
    }

    public static void View(String formId, String content) throws Exception {
        InvokeHelper.Invoke("View", formId, content);
    }

    public static void Delete(String formId, String content) throws Exception {
        InvokeHelper.Invoke("Delete", formId, content);
    }

    public static void Submit(String formId, String content) throws Exception {
        InvokeHelper.Invoke("Submit", formId, content);
    }

    public static void Audit(String formId, String content) throws Exception {
        InvokeHelper.Invoke("Audit", formId, content);
    }

    public static void UnAudit(String formId, String content) throws Exception {
        InvokeHelper.Invoke("UnAudit", formId, content);
    }

    public static void StatusConvert(String formId, String content) throws Exception {
        InvokeHelper.Invoke("StatusConvert", formId, content);
    }

    private static void Invoke(String deal, String formId, String content) throws Exception {
        String line;
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        jParas.add((Object)formId);
        jParas.add((Object)content);
        HttpURLConnection connectionInvoke = InvokeHelper.initUrlConn(sUrl, jParas);
        BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));
        System.out.println(" ============================= ");
        System.out.println(" Contents of post request ");
        System.out.println(" ============================= ");
        while ((line = reader.readLine()) != null) {
            String sResult = new String(line.getBytes(), "utf-8");
            System.out.println(sResult);
        }
        System.out.println(" ============================= ");
        System.out.println(" Contents of post request ends ");
        System.out.println(" ============================= ");
        reader.close();
        connectionInvoke.disconnect();
    }

    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + "\\u" + Integer.toHexString(chr1) : result + str.charAt(i);
        }
        return result;
    }

    static {
        map.put("Save", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc");
        map.put("View", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.View.common.kdsvc");
        map.put("Delete", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        map.put("Submit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Submit.common.kdsvc");
        map.put("Audit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Audit.common.kdsvc");
        map.put("UnAudit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UnAudit.common.kdsvc");
        map.put("StatusConvert", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.StatusConvert.common.kdsvc");
    }
}

