/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.service.IBillVoucherSetService;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.service.VoucherParamsBuilder;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.OriginVoucher;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherBusinessService {
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private VoucherParamsBuilder voucherParamsBuilder;
    @Autowired
    private IBillVoucherSetService billVoucherSetService;

    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        this.voucherParamsBuilder.buildVoucherParams(voucherParams);
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue()) {
            OriginVoucher originVoucher = voucherParams.getOriginVoucher();
        }
        if (voucherParams.getIsGenerateFinanceVoucherFlag().booleanValue()) {
            String systemCode = voucherParams.getSystemCode();
            return this.getFinanceVoucherService(systemCode).save(voucherParams);
        }
        return CommonResponse.success();
    }

    public CommonResponse<Map<String, Object>> get(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getSystemCode()).get(voucherInfo);
    }

    public CommonResponse del(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getSystemCode()).del(voucherInfo);
    }

    public Boolean isGenerateVoucher(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper voucherSetEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        voucherSetEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
        voucherSetEntityLambdaQueryWrapper.eq(BillVoucherSetEntity::getBillTypeCode, (Object)billTypeCode);
        BillVoucherSetEntity voucherSetEntity = (BillVoucherSetEntity)((Object)this.billVoucherSetService.getOne((Wrapper)voucherSetEntityLambdaQueryWrapper));
        if (voucherSetEntity != null) {
            voucherParams.setBillVoucherSetVO((BillVoucherSetVO)BeanMapper.map((Object)((Object)voucherSetEntity), BillVoucherSetVO.class));
            return voucherSetEntity.getEnabled() == 1;
        }
        return Boolean.FALSE;
    }

    private IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        return this.voucherServiceFactory.getFinanceVoucherService(systemCode);
    }
}

