/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.service.IBillVoucherSetService;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.OriginVoucher;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VoucherParamsBuilder {
    private static final Logger logger = LoggerFactory.getLogger(VoucherParamsBuilder.class);
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private IBillVoucherSetService billVoucherSetService;

    public VoucherParams buildVoucherParams(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        String systemCode = "kingDeeGalaxy";
        voucherParams.setSystemCode(systemCode);
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        String serviceName = Optional.ofNullable(billVoucherSetVO.getCustomTransferServiceName()).orElse("commonVoucherTransferService");
        IVoucherTransferService voucherTransferService = this.voucherServiceFactory.getVoucherTransferService(serviceName);
        voucherTransferService.transfer(voucherParams);
        this.checkVoucherParams(voucherParams);
        return voucherParams;
    }

    private void checkVoucherParams(VoucherParams voucherParams) {
        Boolean isGenerateOriginVoucherFlag = voucherParams.getIsGenerateOriginVoucherFlag();
        Boolean isGenerateFinanceVoucherFlag = voucherParams.getIsGenerateFinanceVoucherFlag();
        OriginVoucher originVoucher = voucherParams.getOriginVoucher();
        Map financeVoucher = voucherParams.getFinanceVoucher();
        if (isGenerateOriginVoucherFlag.booleanValue() && originVoucher == null) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u539f\u59cb\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u4f46\u7f3a\u4e4f\u539f\u59cb\u51ed\u8bc1\u6570\u636e[originVoucher]");
        }
        if (isGenerateFinanceVoucherFlag.booleanValue() && financeVoucher == null) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u8d22\u52a1\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u7f3a\u4e4f\u8d22\u52a1\u51ed\u8bc1\u53c2\u6570[financeVoucher]");
        }
    }

    public void getExtraParams(String value, String referCode) {
        JSONArray jsonArray = null;
        try {
            jsonArray = ReferObjectUtil.getReferEntityValue((String)value, (String)referCode);
        }
        catch (Exception var16) {
            try {
                jsonArray = ReferObjectUtil.getReferEntityValue((String)value, (String)referCode);
            }
            catch (Exception var15) {
                logger.error("referCode:" + referCode + " id\uff1a" + value + "\u8f6c\u6362\u51fa\u9519\uff0c--" + var16.getMessage(), (Throwable)var16);
            }
        }
        jsonArray.get(0);
    }

    public String getReferValue(String value, String referCode) {
        try {
            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)value, (String)referCode);
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                String name = json.get((Object)"name") != null ? json.get((Object)"name").toString() : "";
                return name;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return value;
    }
}

