/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.transfer;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.bean.BillAccbookSetEntity;
import com.ejianc.business.accplat.bean.BillAuxiliarySetEntity;
import com.ejianc.business.accplat.bean.BillInfluenceSetEntity;
import com.ejianc.business.accplat.service.IBillAccbookSetService;
import com.ejianc.business.accplat.service.IBillAuxiliarySetService;
import com.ejianc.business.accplat.service.IBillInfluenceSetService;
import com.ejianc.business.accplat.service.ISubjectContrastService;
import com.ejianc.business.accplat.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.vo.BillAuxiliarySetVO;
import com.ejianc.business.accplat.vo.BillInfluenceSetVO;
import com.ejianc.business.accplat.vo.SubjectContrastDetailInfluenceVO;
import com.ejianc.business.accplat.vo.SubjectContrastDetailVO;
import com.ejianc.business.accplat.vo.SubjectContrastVO;
import com.ejianc.business.accplat.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.dto.EntriesDTO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.service.VoucherTemplateCacheProvider;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseVoucherTransferService {
    private static final Logger log = LoggerFactory.getLogger(BaseVoucherTransferService.class);
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private VoucherTemplateCacheProvider voucherTemplateCacheProvider;
    @Autowired
    private IBillAccbookSetService billAccbookSetService;
    @Autowired
    private IBillInfluenceSetService billInfluenceSetService;
    @Autowired
    private IBillAuxiliarySetService billAuxiliarySetService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISubjectContrastService subjectContrastService;

    public Map<String, EntriesDTO> analysisEntries(String billTypeCode, String subjectCategoryCode, Map<String, Object> billData, String mainMnyColName, String subMnyColName) {
        BigDecimal mny = ComputeUtil.toBigDecimal((Object)billData.get(mainMnyColName));
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====start====================================");
        LinkedHashMap<String, EntriesDTO> debitMap = new LinkedHashMap<String, EntriesDTO>();
        SubjectContrastVO subjectContrast = this.getSubjectContrast(null, subjectCategoryCode);
        List subjectContrastDetailList = subjectContrast.getSubjectContrastDetailList();
        List<BillInfluenceSetVO> billInfluenceSetList = this.getBillInfluenceSet(billTypeCode);
        Map<Long, String> billInfluenceSetMap = billInfluenceSetList.stream().collect(Collectors.toMap(BillInfluenceSetVO::getInfluenceId, msg -> msg.getColumnExpression()));
        if (CollectionUtils.isEmpty((Collection)subjectContrastDetailList)) {
            String defaultSubjectCode = subjectContrast.getDefaultSubjectCode();
            if (debitMap.containsKey(defaultSubjectCode)) {
                EntriesDTO entriesDTO = (EntriesDTO)debitMap.get(defaultSubjectCode);
                entriesDTO.setMny(ComputeUtil.safeAdd((BigDecimal)entriesDTO.getMny(), (BigDecimal)mny));
            } else {
                EntriesDTO debitDTO = EntriesDTO.newDebitDTO(defaultSubjectCode);
                debitDTO.setMny(mny);
                debitMap.put(defaultSubjectCode, debitDTO);
            }
        } else {
            for (SubjectContrastDetailVO subjectContrastDetailVO : subjectContrastDetailList) {
                String accountSubjectCode = subjectContrastDetailVO.getAccountSubjectCode();
                List subjectContrastDetailInfluenceList = subjectContrastDetailVO.getSubjectContrastDetailInfluenceList();
                LinkedList<String> expressionList = new LinkedList<String>();
                String expressionString = null;
                for (SubjectContrastDetailInfluenceVO subjectContrastDetailInfluenceVO : subjectContrastDetailInfluenceList) {
                    Long influenceId = subjectContrastDetailInfluenceVO.getInfluenceId();
                    String influenceValue = subjectContrastDetailInfluenceVO.getInfluenceValue();
                    String columnExpression = billInfluenceSetMap.get(influenceId);
                    if (StringUtils.isBlank((CharSequence)columnExpression)) {
                        throw new BusinessException("\u4f1a\u8ba1\u5e73\u53f0\u914d\u7f6e-\u5f71\u54cd\u56e0\u7d20\u5173\u8054\u672a\u914d\u7f6e\u5b57\u6bb5\u3010" + columnExpression + "\u3011");
                    }
                    expressionList.add(columnExpression + "==" + influenceValue);
                    expressionString = "'" + columnExpression + " : '  + " + columnExpression;
                    Expression expression1 = AviatorEvaluator.getInstance().compile(expressionString);
                    Object execute = expression1.execute(billData);
                    log.info(execute.toString());
                }
                expressionString = String.join((CharSequence)" && ", expressionList);
                Expression expression = AviatorEvaluator.getInstance().compile(expressionString);
                boolean b = (Boolean)expression.execute(billData);
                log.info(expressionString + ": " + b);
                if (!b) continue;
                EntriesDTO debitDTO = EntriesDTO.newDebitDTO(accountSubjectCode);
                debitDTO.setMny(mny);
                if (debitMap.containsKey(accountSubjectCode)) {
                    EntriesDTO entriesDTO = (EntriesDTO)debitMap.get(accountSubjectCode);
                    entriesDTO.setMny(ComputeUtil.safeAdd((BigDecimal)entriesDTO.getMny(), (BigDecimal)mny));
                    continue;
                }
                EntriesDTO debitDTO1 = EntriesDTO.newDebitDTO(accountSubjectCode);
                debitDTO1.setMny(mny);
                debitMap.put(accountSubjectCode, debitDTO1);
            }
        }
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====end======================================");
        return debitMap;
    }

    public SubjectContrastVO getSubjectContrast(String subjectChartCode, String subjectCategoryCode) {
        return this.subjectContrastService.getOneBySubjectCategoryCode(subjectChartCode, subjectCategoryCode);
    }

    public List<BillAuxiliarySetVO> getBillAuxiliarySet(String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAuxiliarySetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billAuxiliarySetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u8f85\u52a9\u6838\u7b97\u9879\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillAuxiliarySetVO.class);
    }

    public List<BillInfluenceSetVO> getBillInfluenceSet(String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillInfluenceSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billInfluenceSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u5f71\u54cd\u56e0\u7d20\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillInfluenceSetVO.class);
    }

    protected BillAccbookSetVO getBillAccbookSet(Long orgId, String billTypeCode) {
        CommonResponse oneById = this.orgApi.getOneById(orgId);
        OrgVO orgVO = (OrgVO)oneById.getData();
        Object[] parentOrgIds = orgVO.getInnerCode().split("\\|");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAccbookSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.in(BillAccbookSetEntity::getSourceOrgId, parentOrgIds);
        List list = this.billAccbookSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u8d26\u7c3f\u6620\u5c04\u89c4\u5219\u3011, orgId:" + orgId);
        }
        Map setMap = list.stream().collect(Collectors.toMap(BillAccbookSetEntity::getSourceOrgId, Function.identity(), (key1, key2) -> key2));
        BillAccbookSetVO billAccbookSetVO = null;
        for (int i = parentOrgIds.length - 1; i >= 0; --i) {
            BillAccbookSetEntity billAccbookSetEntity = (BillAccbookSetEntity)((Object)setMap.get(Long.valueOf((String)parentOrgIds[i])));
            if (billAccbookSetEntity == null) continue;
            billAccbookSetVO = (BillAccbookSetVO)BeanMapper.map((Object)((Object)billAccbookSetEntity), BillAccbookSetVO.class);
            break;
        }
        return billAccbookSetVO;
    }

    public void transfer(VoucherParams voucherParams) {
        voucherParams.setIsGenerateOriginVoucherFlag(this.getIsGenerateOriginVoucherFlag(voucherParams));
        voucherParams.setIsGenerateFinanceVoucherFlag(this.getIsGenerateFinanceVoucherFlag(voucherParams));
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue()) {
            this.transferOriginVoucher(voucherParams);
        }
        if (voucherParams.getIsGenerateFinanceVoucherFlag().booleanValue()) {
            this.transferFinanceVoucher(voucherParams);
        }
    }

    public void transferOriginVoucher(VoucherParams voucherParams) {
        this.transferOriginVoucherByVoucherTemplate(voucherParams);
    }

    public void transferFinanceVoucher(VoucherParams voucherParams) {
        this.transferFinanceVoucherByOriginVoucher(voucherParams);
    }

    private void transferOriginVoucherByVoucherTemplate(VoucherParams voucherParams) {
        VoucherTemplateVO voucherTemplateVO = this.voucherTemplateCacheProvider.loadTemplateFromCache(InvocationInfoProxy.getTenantid(), voucherParams.getBillTypeCode());
        voucherParams.setOriginVoucher(null);
    }

    public void transferFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        String systemCode = voucherParams.getSystemCode();
        IFinanceVoucherService financeVoucherService = this.voucherServiceFactory.getFinanceVoucherService(systemCode);
        financeVoucherService.convertToFinanceVoucherByOriginVoucher(voucherParams);
    }

    public Boolean getIsGenerateOriginVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }

    public Boolean getIsGenerateFinanceVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }
}

