/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.exception;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class UCFException
extends RuntimeException {
    public UCFException(String message) {
        super(message);
    }

    public UCFException(String message, Throwable cause) {
        super(message, cause);
    }

    public abstract int getCode();

    public final int getHttpCode() {
        int code = this.getCode();
        if (code > 9999999) {
            return code / 100000;
        }
        if (code > 999999) {
            return code / 10000;
        }
        if (code > 99999) {
            return code / 1000;
        }
        if (code > 9999) {
            return code / 100;
        }
        if (code > 1000) {
            return code / 10;
        }
        return code;
    }

    public Map<Locale, String> getDisplayMessage() {
        HashMap<Locale, String> message = new HashMap<Locale, String>(3);
        if (this.getHttpCode() > 499) {
            message.put(Locale.SIMPLIFIED_CHINESE, "\u7cfb\u7edf\u53d1\u751f\u9519\u8bef");
            message.put(Locale.TRADITIONAL_CHINESE, "\u7cfb\u7d71\u767c\u751f\u932f\u8aa4");
            message.put(Locale.US, "System Error.");
        } else if (this.getHttpCode() > 399) {
            message.put(Locale.SIMPLIFIED_CHINESE, "\u53c2\u6570\u9519\u8bef");
            message.put(Locale.TRADITIONAL_CHINESE, "\u53c3\u6578\u932f\u8aa4");
            message.put(Locale.US, "Parameter Invalid.");
        }
        return message;
    }
}

