/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.network.cryptor;

import com.ejianc.business.yonyou.base.exception.BusinessException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA1 {
    private static final Logger log = LoggerFactory.getLogger(SHA1.class);

    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) {
        Object[] array = new String[]{token, timestamp, nonce, encrypt};
        StringBuilder builder = new StringBuilder();
        Arrays.sort(array);
        for (int i = 0; i < 4; ++i) {
            builder.append((String)array[i]);
        }
        String str = builder.toString();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            String message = "SHA-1 message digest not exists";
            log.error(message, (Throwable)e);
            throw new BusinessException(message, e);
        }
        md.update(str.getBytes());
        byte[] digest = md.digest();
        StringBuilder result = new StringBuilder();
        for (byte b : digest) {
            String shaHex = Integer.toHexString(b & 0xFF);
            if (shaHex.length() < 2) {
                result.append(0);
            }
            result.append(shaHex);
        }
        return result.toString();
    }
}

