/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.business.yonyou.api.BaseOpenApi;
import com.ejianc.business.yonyou.base.context.InvocationInfoProxy;
import com.ejianc.business.yonyou.base.module.reponse.ApiDataResponse;
import com.ejianc.business.yonyou.base.properties.UCFCoreProperties;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class YonYouYsVoucherService
extends BaseOpenApi
implements IFinanceVoucherService {
    @Resource
    UCFCoreProperties ucfCoreProperties;

    public boolean check() {
        if (this.ucfCoreProperties.getAccessType()) {
            String tenantId = null;
            if (tenantId == null) {
                throw new BusinessException("ISV\u6a21\u5f0f");
            }
            InvocationInfoProxy.setTenantId(tenantId);
        }
        return true;
    }

    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        this.check();
        Map params = voucherParams.getFinanceVoucher();
        String supplierCode = Optional.ofNullable(params.get("supplierCode")).orElse("00LW000001");
        String projectCode = Optional.ofNullable(params.get("projectCode")).orElse("XM001");
        String projectName = Optional.ofNullable(params.get("projectName")).orElse("\u76ca\u4f01\u8054\u79d1\u6280\u5927\u53a6");
        String description = projectName + "_\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97";
        Object taxMny = params.get("taxMny");
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCode", "JZ");
        params.put("makerMobile", "13520563725");
        JSONObject body1 = new JSONObject();
        body1.put("description", (Object)description);
        body1.put("accsubjectCode", (Object)"590101");
        body1.put("debitOriginal", taxMny);
        body1.put("debitOrg", taxMny);
        body1.put("debitGroup", taxMny);
        body1.put("debitGlobal", taxMny);
        body1.put("organizeDebitAmount", taxMny);
        JSONArray clientAuxiliaryList1 = new JSONArray();
        JSONObject clientAuxiliaryList1_1 = new JSONObject();
        clientAuxiliaryList1_1.put("filedCode", (Object)"0002");
        clientAuxiliaryList1_1.put("valueCode", (Object)projectCode);
        clientAuxiliaryList1.add((Object)clientAuxiliaryList1_1);
        body1.put("clientAuxiliaryList", (Object)clientAuxiliaryList1);
        JSONObject body2 = new JSONObject();
        body2.put("description", (Object)description);
        body2.put("accsubjectCode", (Object)"220201");
        body2.put("creditOriginal", taxMny);
        body2.put("creditOrg", taxMny);
        body2.put("creditGroup", taxMny);
        body2.put("creditGlobal", taxMny);
        body2.put("organizeCreditAmount", taxMny);
        JSONArray clientAuxiliaryList2 = new JSONArray();
        JSONObject clientAuxiliaryList2_1 = new JSONObject();
        clientAuxiliaryList2_1.put("filedCode", (Object)"0002");
        clientAuxiliaryList2_1.put("valueCode", (Object)projectCode);
        clientAuxiliaryList2.add((Object)clientAuxiliaryList2_1);
        JSONObject clientAuxiliaryList2_2 = new JSONObject();
        clientAuxiliaryList2_2.put("filedCode", (Object)"0004");
        clientAuxiliaryList2_2.put("valueCode", (Object)supplierCode);
        clientAuxiliaryList2.add((Object)clientAuxiliaryList2_2);
        body2.put("clientAuxiliaryList", (Object)clientAuxiliaryList2);
        JSONArray bodies = new JSONArray();
        bodies.add((Object)body1);
        bodies.add((Object)body2);
        params.put("bodies", bodies);
        ApiDataResponse apiDataResponse = this.postForEntity("/yonbip/fi/ficloud/openapi/voucher/addVoucher", params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();
        if (commonResponse.isSuccess()) {
            Map data = (Map)commonResponse.getData();
            VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
            voucherSimpleVO.setVoucherId(data.get("voucherId").toString());
            voucherSimpleVO.setPeriod(data.get("period").toString());
            voucherSimpleVO.setBillCode(data.get("billCode").toString());
            commonResponse.setData((Object)VoucherInfo.getVoucherInfo((VoucherSimpleVO)voucherSimpleVO));
        }
        return commonResponse;
    }

    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        return null;
    }

    @Override
    public CommonResponse get(VoucherInfo voucherInfo) {
        Map data;
        List recordList;
        VoucherSimpleVO voucherSimpleVO = (VoucherSimpleVO)voucherInfo.getVouchers().get(0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCodeList", Arrays.asList("JZ"));
        params.put("periodStart", voucherSimpleVO.getPeriod());
        params.put("periodEnd", voucherSimpleVO.getPeriod());
        params.put("billcodeMin", voucherSimpleVO.getBillCode());
        params.put("billcodeMax", voucherSimpleVO.getBillCode());
        JSONObject pager = new JSONObject();
        pager.put("pageIndex", (Object)1);
        pager.put("pageSize", (Object)500);
        params.put("pager", pager);
        ApiDataResponse apiDataResponse = this.postForEntity("/yonbip/fi/ficloud/openapi/voucher/queryVouchers", params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(recordList = (List)(data = (Map)commonResponse.getData()).get("recordList")))) {
            commonResponse.setData(recordList.get(0));
        }
        return commonResponse;
    }

    @Override
    public CommonResponse getList(VoucherInfo voucherInfo) {
        return null;
    }

    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        List vouchers = voucherInfo.getVouchers();
        if (CollectionUtils.isNotEmpty((Collection)vouchers)) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("ids", Arrays.asList(((VoucherSimpleVO)vouchers.get(0)).getVoucherId()));
            ApiDataResponse apiDataResponse = this.postForEntity("/yonbip/fi/voucher/del", params, ApiDataResponse.class);
            apiDataResponse.toCommonResponse();
        }
        return CommonResponse.success();
    }

    @Override
    public VoucherParams convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        return voucherParams;
    }
}

