package com.ejianc.business.custom.transfer.sjyg;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.kingdee.base.vo.save.*;
import com.ejianc.business.voucher.dto.EntriesDTO;
import com.ejianc.business.voucher.transfer.BaseVoucherTransferService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @description: 凭证自定义转化-分包过程结算
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Slf4j
@Service("SJYG-SubSettleVoucherCustomTransferService")
public class SJYGSubSettleVoucherCustomTransferService extends BaseVoucherTransferService implements IVoucherTransferService {

    // 科目表编码
    private static final String SUBJECT_CHART_CODE = "PRE001";
    // 借方科目分类编码
    private static final String SUBJECT_CONTRAST_CATEGORY_CODE_DEBIT_1 = "subSettle01";
    // 贷方科目分类编码
    private static final String SUBJECT_CONTRAST_CATEGORY_CODE_CREDIT_1 = "subSettle02";

    // 金额字段
    private static final String MNY_COL_NAME = "settleTaxMny";


    /**
     * @description: 转化原始凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据凭证模板转化原始凭证，可以直接调用transferOriginVoucherByVoucherTemplate
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以根据定义分录转化原始凭证，
     *    如不需要复写getIsGenerateOriginVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferOriginVoucher(VoucherParams voucherParams) {

    }

    /**
     * @description: 转化财务凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据原始凭证转化财务凭证，可以直接调用transferFinanceVoucherByOriginVoucher
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以根据定义分录直接转化财务凭证（或者自定义也转化了原始凭证，可以直接调用transferFinanceVoucherByOriginVoucher），
     *    如不需要复写getIsGenerateFinanceVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferFinanceVoucher(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        Map<String, Object> billData = voucherParams.getBillData();
        Object _orgId = billData.get("orgId");
        Object projectName = billData.get("projectName");
        Object date = billData.get("settleDate");


        KingDeeVoucherApiSaveVO kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        Model model = new Model();
        // 1、设置账簿
        Long orgId = Long.valueOf(String.valueOf(_orgId));
        BillAccbookSetVO billAccbookSetVO = this.getBillAccbookSet(orgId, billTypeCode);
        log.info("billAccbookSetVO:{}", JSONObject.toJSONString(billAccbookSetVO));

        FAccountBookID fAccountBookID = new FAccountBookID();
        fAccountBookID.setFNumber(billAccbookSetVO.getAccbookCode());
        model.setFAccountBookID(fAccountBookID);
        // 日期
        model.setFDate(date.toString());
        // FBUSDATE 业务日期
        //model.setFBUSDATE("Z");


        // FYEAR 会计年度

        // FPERIOD 期间

        // FVOUCHERGROUPID 凭证字
       /* FVOUCHERGROUPID fvouchergroupid = new FVOUCHERGROUPID();
        fvouchergroupid.setFNumber("PRE001");
        model.setFVOUCHERGROUPID(fvouchergroupid);*/
        // FDocumentStatus 审核状态
        //model.setFDocumentStatus("Z");


        List<EntriesDTO> debitList = this.analysisEntries(billTypeCode, SUBJECT_CONTRAST_CATEGORY_CODE_DEBIT_1, billData, MNY_COL_NAME);

        List<EntriesDTO> crebitList = this.analysisEntries(billTypeCode, SUBJECT_CONTRAST_CATEGORY_CODE_CREDIT_1, billData, MNY_COL_NAME);

        List<FEntity> fEntityList = new ArrayList<>();
        for (EntriesDTO entriesDTO : debitList) {
            FEntity fEntity1 = new FEntity();
            // 摘要
            fEntity1.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
            // FACCOUNTID 科目编码
            FACCOUNTID faccountid = new FACCOUNTID();
            faccountid.setFNumber(entriesDTO.getSubjectCode());
            fEntity1.setFACCOUNTID(faccountid);
            // FAMOUNTFOR 原币金额
            fEntity1.setFAMOUNTFOR(entriesDTO.getMny());
            // FDEBIT 借方金额
            fEntity1.setFDEBIT(entriesDTO.getMny());
            // FCURRENCYID 币别
            FCURRENCYID fcurrencyid = new FCURRENCYID();
            fcurrencyid.setFNumber("PRE001");
            fEntity1.setFCURRENCYID(fcurrencyid);

            // FEXCHANGERATETYPE 汇率类型
            FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
            fexchangeratetype.setFNumber("HLTX01_SYS");
            fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);


            fEntityList.add(fEntity1);
        }

        for (EntriesDTO entriesDTO : crebitList) {
            FEntity fEntity1 = new FEntity();
            // 摘要
            fEntity1.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
            // FACCOUNTID 科目编码
            FACCOUNTID faccountid = new FACCOUNTID();
            faccountid.setFNumber(entriesDTO.getSubjectCode());
            fEntity1.setFACCOUNTID(faccountid);
            // FAMOUNTFOR 原币金额
            fEntity1.setFAMOUNTFOR(entriesDTO.getMny());
            // FDEBIT 借方金额
            fEntity1.setFCREDIT(entriesDTO.getMny());
            // FCURRENCYID 币别
            FCURRENCYID fcurrencyid = new FCURRENCYID();
            fcurrencyid.setFNumber("PRE001");
            fEntity1.setFCURRENCYID(fcurrencyid);

            // FEXCHANGERATETYPE 汇率类型
            FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
            fexchangeratetype.setFNumber("HLTX01_SYS");
            fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);


            fEntityList.add(fEntity1);
        }



        /*   FEntity fEntity1 = new FEntity();
         *//*  // FACCOUNTID 科目编码
        FACCOUNTID faccountid = new FACCOUNTID();
        faccountid.setFNumber("2202.02");
        fEntity1.setFACCOUNTID(faccountid);*//*



        // 摘要
        fEntity1.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
        // FAMOUNTFOR 原币金额
        //fEntity1.setFAMOUNTFOR(mny);
        // FDEBIT 借方金额
        //fEntity1.setFDEBIT(mny);

        // FCURRENCYID 币别
        FCURRENCYID fcurrencyid = new FCURRENCYID();
        fcurrencyid.setFNumber("PRE001");
        fEntity1.setFCURRENCYID(fcurrencyid);

        // FEXCHANGERATETYPE 汇率类型
        FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
        fexchangeratetype.setFNumber("HLTX01_SYS");
        fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);



        // FDetailID 核算对象
        FDetailID fDetailID = new FDetailID();
        FDETAILID__FFLEX4 fdetailid__fflex4 = new FDETAILID__FFLEX4();
        fdetailid__fflex4.setFNumber("1.001");
        fDetailID.setFDETAILID__FFLEX4(fdetailid__fflex4);
        fEntity1.setFDetailID(fDetailID);


        FEntity fEntity2 = new FEntity();
        // FACCOUNTID 科目编码
        FACCOUNTID faccountid2 = new FACCOUNTID();
        faccountid2.setFNumber("1001.01");
        fEntity2.setFACCOUNTID(faccountid2);
        // 摘要
        fEntity2.setFEXPLANATION(projectName + "_" + billVoucherSetVO.getBillTypeName());
        // FAMOUNTFOR 原币金额
        //fEntity2.setFAMOUNTFOR(mny);
        // FCREDIT 贷方金额
        //fEntity2.setFCREDIT(mny);

        // FCURRENCYID 币别
        fEntity2.setFCURRENCYID(fcurrencyid);

        // FEXCHANGERATETYPE 汇率类型
        fEntity2.setFEXCHANGERATETYPE(fexchangeratetype);*/


        model.setFEntity(fEntityList);
        kingDeeVoucherApiSaveVO.setModel(model);
        voucherParams.setFinanceVoucher(DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO));
    }


    /**
     * @description: 是否生成原始凭证，如为true，请在transferOriginVoucher中转化
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public Boolean getIsGenerateOriginVoucherFlag(VoucherParams voucherParams) {
        return Boolean.FALSE;
    }


    public static void main(String[] args) {
        // 创建 Aviator 表达式
        String expressionString = "'x:' + x";

        // 编译表达式
        Expression expression = AviatorEvaluator.getInstance().compile(expressionString);

        // 定义变量
        Map<String, Object> variables = new HashMap<>();
        variables.put("x", 10);
        variables.put("y", "10");

        // 第一次执行表达式
        Object result1 = expression.execute(variables);
        System.out.println("Result 1: " + result1); // 输出 Result 1: 15

        // 修改变量值
        variables.put("x", 20);
        variables.put("y", 8);

        // 第二次执行表达式
        Object result2 = expression.execute(variables);
        System.out.println("Result 2: " + result2); // 输出 Result 2: 28
    }


}
