package com.ejianc.business.voucher.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 分录封装模型
 * @author songlx
 * @date 2023/12/21
 * @version 1.0
 */
@Data
public class EntriesDTO {


    //科目编码
    private String subjectCode;

    // 借贷方向 1 借 2 贷
    private Integer flag;

    // 金额
    private BigDecimal mny;

    // 摘要
    private String remark;


    public static EntriesDTO newDebitDTO(String subjectCode) {
        return new EntriesDTO(1, subjectCode);
    }


    public static EntriesDTO newCreditDTO(String subjectCode) {
        return new EntriesDTO(2, subjectCode);
    }

    public EntriesDTO(Integer flag, String subjectCode) {
        this.flag = flag;
        this.subjectCode = subjectCode;
    }

    public EntriesDTO() {
    }
}
