package com.ejianc.business.voucher.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.service.IBillVoucherSetService;
import com.ejianc.business.accplat.vo.BillVoucherSetVO;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.OriginVoucher;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: VoucherBusinessService
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Slf4j
@Service
public class VoucherBusinessService {


    @Autowired
    private VoucherServiceFactory voucherServiceFactory;

    @Autowired
    private VoucherParamsBuilder voucherParamsBuilder;


    @Autowired
    private IBillVoucherSetService billVoucherSetService;

    /**
     * @description: 保存凭证
     * 1、构建凭证参数
     * 2、保存原始凭证，可以根据参数动态判断是否需要保存原始凭证
     * 3、推送财务凭证
     * @param voucherParams
     * @return {@link CommonResponse<VoucherInfo>}
     * @author songlx
     * @date: 2023/11/28
     */
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        // 1、构建凭证参数
        voucherParamsBuilder.buildVoucherParams(voucherParams);
        // 2、保存原始凭证
        if (voucherParams.getIsGenerateOriginVoucherFlag()) {
            OriginVoucher originVoucher = voucherParams.getOriginVoucher();
        }
        log.info(" ============================= ");
        log.info("金蝶云星空接口save:" + DataConvertUtil.objToString(voucherParams.getFinanceVoucher()));
        log.info(" ============================= ");
        // 3、推送财务凭证
        if (voucherParams.getIsGenerateFinanceVoucherFlag()) {
            String systemCode = voucherParams.getSystemCode();
            return getFinanceVoucherService(systemCode).save(voucherParams);
        }
        return CommonResponse.success();
    }


    /**
     * @description: 查询凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse< Map< String, Object>>}
     * @author songlx
     * @date: 2023/11/30
     */
    public CommonResponse<Map<String, Object>> get(VoucherInfo voucherInfo) {
        return getFinanceVoucherService(voucherInfo.getSystemCode()).get(voucherInfo);
    }

    /**
     * @description: 删除凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2023/11/30
     */
    public CommonResponse del(VoucherInfo voucherInfo) {
        return getFinanceVoucherService(voucherInfo.getSystemCode()).del(voucherInfo);
    }


    /**
     * @description: 根据单据类型编码和单据数据查询单据设置判断是否需要传凭证
     *
     * @param voucherParams
     * @return {@link Boolean}
     * @author songlx
     * @date: 2023/12/1
     */
    public Boolean isGenerateVoucher(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<BillVoucherSetEntity> voucherSetEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        voucherSetEntityLambdaQueryWrapper.eq(BillVoucherSetEntity::getTenantId, tenantid);
        voucherSetEntityLambdaQueryWrapper.eq(BillVoucherSetEntity::getBillTypeCode, billTypeCode);
        BillVoucherSetEntity voucherSetEntity = billVoucherSetService.getOne(voucherSetEntityLambdaQueryWrapper);
        if (voucherSetEntity != null) {
            voucherParams.setBillVoucherSetVO(BeanMapper.map(voucherSetEntity, BillVoucherSetVO.class));
            return voucherSetEntity.getEnabled().intValue() == 1;
        }
        return Boolean.FALSE;
    }


    /**
     * @description: 根据财务系统标识获取对应的财务会计服务
     * @author songlx
     * @date: 2023/11/30
     */
    private IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        return voucherServiceFactory.getFinanceVoucherService(systemCode);
    }

}
