package com.ejianc.business.voucher.transfer;

import com.ejianc.business.voucher.vo.VoucherParams;
import org.springframework.stereotype.Service;

/**
 * @description: 公共凭证转化服务
 *
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service("commonVoucherTransferService")
public class CommonVoucherTransferService extends BaseVoucherTransferService implements IVoucherTransferService {


    /**
     * @description: 转化原始凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据凭证模板转化原始凭证，可以直接调用transferOriginVoucherByVoucherTemplate
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以自己定义分录转化原始凭证，
     *    如不需要，复写getIsGenerateOriginVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferOriginVoucher(VoucherParams voucherParams) {
        super.transferOriginVoucher(voucherParams);
    }

    /**
     * @description: 转化财务凭证，子类复写，有以下两种情况
     * 1、公共CommonVoucherTransferService 根据原始凭证转化财务凭证，可以直接调用transferFinanceVoucherByOriginVoucher
     * 2、自定义转化服务（如SubSettleVoucherCustomTransferService）可以根据定义分录直接转化财务凭证（或者自定义也转化了原始凭证，可以直接调用transferFinanceVoucherByOriginVoucher），
     *    如不需要复写getIsGenerateFinanceVoucherFlag返回false
     * @param voucherParams
     * @return
     * @author songlx
     * @date: 2023/12/1
     */
    @Override
    public void transferFinanceVoucher(VoucherParams voucherParams) {
        super.transferFinanceVoucher(voucherParams);
    }


}
