package com.ejianc.business.voucher.utils;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: AviatorUtil
 * @author songlx
 * @date 2023/12/22
 * @version 1.0
 */
public class AviatorUtil {


    static {
        initSelfFunction();
    }

    private static void initSelfFunction() {
        AviatorEvaluator.addFunction(new eq());
    }


    public static class eq extends AbstractFunction {
        @Override
        public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
            String v1 = FunctionUtils.getStringValue(arg1, env);
            String v2 = null;
            if (arg2 instanceof AviatorNumber) {
                Long numberValue = FunctionUtils.getNumberValue(arg2, env).longValue();
                v2 = String.valueOf(numberValue);
            } else {
                v2 = FunctionUtils.getStringValue(arg2, env);
            }
            return AviatorBoolean.valueOf(v1.equals(v2));
        }

        public String getName() {
            return "eq";
        }
    }

    public static String getEqExpression(String key, String val) {
        return " eq(" + key + "," + val + ") ";
    }

    public static boolean execEq(String express, Map map) {
        return (Boolean) exec(express, map);
    }


    public static Object exec(String express, Map map) {
        return AviatorEvaluator.execute(express, map);
    }


    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("a", "1");
        String express = "eq(a,1) ";
        System.out.println(exec(express, map));
    }


}

